/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model.cmd;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.PropertyType;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.util.SgfRectangle;
import org.unitarou.yukinoshita.model.cmd.Command4NodeList;
import org.unitarou.yukinoshita.model.cmd.ModelInfluence;
import org.unitarou.yukinoshita.model.cmd.UpdateProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetVwAtRoot
extends Command4NodeList {
    private UpdateProperty command_ = null;
    private SgfSize sgfSize_ = null;

    @Override
    protected boolean setup() {
        Property[] propertyArray;
        Property append;
        if (this.command_ != null) {
            return true;
        }
        if (this.getEditableNodeList() == null) {
            return false;
        }
        RootGameTree root = this.getEditableNodeList().getRoot();
        this.sgfSize_ = root.getSize();
        ArrayList<SgfPoint> allStones = new ArrayList<SgfPoint>(this.sgfSize_.width() * this.sgfSize_.height());
        this.addAllStones(root, allStones);
        if (allStones.isEmpty()) {
            append = null;
        } else {
            SgfRectangle sgfRectangle = SgfRectangle.create(allStones.toArray(new SgfPoint[allStones.size()]));
            SgfPoint start = sgfRectangle.getStart();
            int sx = 1 < start.x() ? start.x() - 1 : start.x();
            int sy = 1 < start.y() ? start.y() - 1 : start.y();
            SgfPoint end = sgfRectangle.getEnd();
            int ex = end.x() < this.sgfSize_.width() ? end.x() + 1 : end.x();
            int ey = end.y() < this.sgfSize_.height() ? end.y() + 1 : end.y();
            sgfRectangle.set(SgfPoint.create(this.sgfSize_, sx, sy), SgfPoint.create(this.sgfSize_, ex, ey));
            append = new Property(SgfId.VIEW, sgfRectangle.getValue());
        }
        Property property = root.getSequence().getFirst().getProperty(SgfId.VIEW);
        if (property != null) {
            Property[] propertyArray2 = new Property[1];
            propertyArray = propertyArray2;
            propertyArray2[0] = property;
        } else {
            propertyArray = new Property[]{};
        }
        Property[] exclude = propertyArray;
        this.command_ = new UpdateProperty(exclude, append, PropertyType.ROOT);
        this.command_.setEditableNodeList(this.getEditableNodeList());
        this.command_.setExecutedNodeIndex(0);
        this.command_.setUndoneNodeIndex(this.getEditableNodeList().getPositionIndex());
        return true;
    }

    private void addAllStones(GameTree gameTree, List<SgfPoint> allStones) {
        for (Node node : gameTree.getSequence()) {
            SgfId[] sgfIdArray = new SgfId[]{SgfId.WHITE, SgfId.BLACK, SgfId.ADD_WHITE, SgfId.ADD_BLACK};
            int n = 0;
            int n2 = sgfIdArray.length;
            while (n < n2) {
                SgfId sgfId = sgfIdArray[n];
                Property property = node.getProperty(sgfId);
                if (property != null) {
                    allStones.addAll((Collection<SgfPoint>)Arrays.asList(SgfPoint.parse(this.sgfSize_, property.value().getStrings())));
                }
                ++n;
            }
        }
        GameTree[] gameTreeArray = gameTree.getChildren();
        int n = 0;
        int n3 = gameTreeArray.length;
        while (n < n3) {
            GameTree child = gameTreeArray[n];
            this.addAllStones(child, allStones);
            ++n;
        }
    }

    @Override
    public void execute() {
        super.execute();
        this.command_.execute();
    }

    @Override
    public void undo() {
        super.undo();
        this.command_.undo();
    }

    @Override
    public EnumSet<ModelInfluence> getInfluence() {
        return EnumSet.of(ModelInfluence.ROOT_GAME_TREE, ModelInfluence.NODE_CURRENT);
    }
}

