/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model.cmd;

import java.util.EnumSet;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.PropertyType;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.Value;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.util.SgfPointType;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.model.EditableNodeList;
import org.unitarou.yukinoshita.model.NodeEntity;
import org.unitarou.yukinoshita.model.cmd.AddNode;
import org.unitarou.yukinoshita.model.cmd.Command4NodeList;
import org.unitarou.yukinoshita.model.cmd.InsertNode;
import org.unitarou.yukinoshita.model.cmd.ModelInfluence;
import org.unitarou.yukinoshita.model.cmd.UpdateProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetStone
extends Command4NodeList {
    private static final MessageResource LB_NAME = new MessageResource(SetStone.class, "lbName");
    private final SgfPoint point_;
    private final SgfColor color_;
    private Command4NodeList actualCommand_;
    private int nodeIndex_;
    static /* synthetic */ Class class$0;

    public SetStone(SgfPoint point, SgfColor color) {
        ArgumentChecker.throwIfNull((Object)point);
        if (point.condition().equals((Object)SgfPointType.PASS)) {
            throw new IllegalArgumentException("Set stone command dosen't permit PASS point");
        }
        this.point_ = point;
        this.color_ = color;
        this.setDisplayName(LB_NAME.get((Object)this.getSetupType(this.color_).displayName()));
    }

    @Override
    protected boolean setup() {
        if (this.actualCommand_ != null) {
            return true;
        }
        EditableNodeList nodeList_ = this.getEditableNodeList();
        if (nodeList_ == null) {
            return false;
        }
        this.nodeIndex_ = nodeList_.getPositionIndex();
        NodeEntity entity = nodeList_.get(this.nodeIndex_);
        if (entity.getNode().contains(PropertyType.MOVE)) {
            this.setExecutedNodeIndex(this.nodeIndex_);
            this.setUndoneNodeIndex(this.nodeIndex_);
            this.actualCommand_ = this.makeCommandForMove();
        } else {
            this.setExecutedNodeIndex(this.nodeIndex_);
            this.setUndoneNodeIndex(this.nodeIndex_);
            this.actualCommand_ = this.makeCommandForRegular();
        }
        return true;
    }

    private Command4NodeList makeCommandForMove() {
        Command4NodeList command;
        Node node = new Node(this.makeSetupMove(this.color_));
        if (this.getEditableNodeList().size() == this.nodeIndex_ + 1) {
            command = new AddNode(node);
            command.setEditableNodeList(this.getEditableNodeList());
        } else {
            command = new InsertNode(this.getEditableNodeList(), node);
        }
        return command;
    }

    private Command4NodeList makeCommandForRegular() {
        Property addBlack = this.makeSetupMove(SgfColor.BLACK);
        Property addWhite = this.makeSetupMove(SgfColor.WHITE);
        Property addEmpty = this.makeSetupMove(null);
        Property[] forRemoves = new Property[2];
        Property forInsert = this.makeSetupMove(this.color_);
        if (SgfColor.BLACK.equals(this.color_)) {
            forRemoves[0] = addWhite;
            forRemoves[1] = addEmpty;
        } else if (SgfColor.WHITE.equals(this.color_)) {
            forRemoves[0] = addBlack;
            forRemoves[1] = addEmpty;
        } else {
            forRemoves[0] = addBlack;
            forRemoves[1] = addWhite;
            Node node = this.getEditableNodeList().get(this.nodeIndex_).getNode();
            SgfId[] sgfIdArray = new SgfId[]{SgfId.ADD_BLACK, SgfId.ADD_WHITE};
            int n = 0;
            int n2 = sgfIdArray.length;
            while (n < n2) {
                SgfId sgfId = sgfIdArray[n];
                Property property = node.getProperty(sgfId);
                if (property != null) {
                    String[] stringArray = property.value().getStrings();
                    int n3 = 0;
                    int n4 = stringArray.length;
                    while (n3 < n4) {
                        String string = stringArray[n3];
                        if (string.equals(this.point_.getString())) {
                            forInsert = null;
                            break;
                        }
                        ++n3;
                    }
                }
                ++n;
            }
        }
        UpdateProperty command = new UpdateProperty(forRemoves, forInsert, null);
        command.setEditableNodeList(this.getEditableNodeList());
        return command;
    }

    private Property makeSetupMove(SgfColor color) {
        Property property = new Property();
        property.setId(this.getSetupType(color).id());
        property.value().addValue(new Value(this.point_.getString()));
        return property;
    }

    private SgfId getSetupType(SgfColor color) {
        if (SgfColor.BLACK.equals(color)) {
            return SgfId.ADD_BLACK;
        }
        if (SgfColor.WHITE.equals(color)) {
            return SgfId.ADD_WHITE;
        }
        return SgfId.ADD_EMPTY;
    }

    @Override
    public void execute() {
        super.execute();
        this.actualCommand_.execute();
    }

    @Override
    public void undo() {
        super.undo();
        this.actualCommand_.undo();
    }

    @Override
    public EnumSet<ModelInfluence> getInfluence() {
        return EnumSet.of(ModelInfluence.NODE_DOWNWARD, ModelInfluence.NODE_CURRENT);
    }
}

