/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model.cmd;

import java.util.EnumSet;
import java.util.LinkedList;
import org.unitarou.cmd.AbstractCommand;
import org.unitarou.cmd.Command;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.GameTree;
import org.unitarou.yukinoshita.model.EditableNodeList;
import org.unitarou.yukinoshita.model.NodeEntity;
import org.unitarou.yukinoshita.model.cmd.Command4NodeList;
import org.unitarou.yukinoshita.model.cmd.ModelInfluence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectVariation
extends Command4NodeList {
    private static final MessageResource LB_NAME = new MessageResource(SelectVariation.class, "lbName");
    private final int newVariationIndex_;
    private NodeEntity targetNode_;
    private int lastIndex_;
    private LinkedList<NodeEntity> removedChain_;
    private Command commandImpl_;
    static /* synthetic */ Class class$0;

    public SelectVariation(int newIndex) {
        if (newIndex < 0) {
            throw new IllegalArgumentException("newIndex must not be negative number: newIndex = " + newIndex);
        }
        this.newVariationIndex_ = newIndex;
        this.commandImpl_ = null;
        this.removedChain_ = null;
    }

    @Override
    protected boolean setup() {
        if (this.commandImpl_ != null) {
            return true;
        }
        EditableNodeList nodeList = this.getEditableNodeList();
        if (nodeList == null) {
            return false;
        }
        this.targetNode_ = nodeList.getPosition();
        if (this.newVariationIndex_ < 0 || this.targetNode_.getNodeTree().getVariationSize() <= this.newVariationIndex_) {
            throw new IndexOutOfBoundsException("A new index is " + this.newVariationIndex_ + " but target.size is " + this.targetNode_.getNodeTree().getVariationSize() + ".");
        }
        this.lastIndex_ = this.targetNode_.getSelectedVariationIndex();
        this.commandImpl_ = this.targetNode_.getNodeTree().isChildrenStyle() ? new SelectVariationAsChildren() : new SelectVariationAsSibling();
        this.setDisplayName(LB_NAME.get());
        this.setExecutedNodeIndex(nodeList.getPositionIndex());
        this.setUndoneNodeIndex(nodeList.getPositionIndex());
        return true;
    }

    @Override
    public void execute() {
        super.execute();
        if (this.newVariationIndex_ == this.lastIndex_) {
            return;
        }
        this.commandImpl_.execute();
    }

    @Override
    public void undo() {
        super.undo();
        if (this.newVariationIndex_ == this.lastIndex_) {
            return;
        }
        this.commandImpl_.undo();
    }

    @Override
    public EnumSet<ModelInfluence> getInfluence() {
        return EnumSet.of(ModelInfluence.NODE_CURRENT);
    }

    private class SelectVariationAsChildren
    extends AbstractCommand {
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            $assertionsDisabled = !SelectVariationAsChildren.class.desiredAssertionStatus();
        }

        public void execute() {
            if (!$assertionsDisabled && !SelectVariation.this.targetNode_.getNodeTree().isChildrenStyle()) {
                throw new AssertionError((Object)"Sibling style must not user this class.");
            }
            super.execute();
            SelectVariation.this.removedChain_ = new LinkedList();
            NodeEntity last = SelectVariation.this.getEditableNodeList().removeLast();
            while (!last.equals(SelectVariation.this.targetNode_)) {
                SelectVariation.this.removedChain_.addFirst(last);
                last = SelectVariation.this.getEditableNodeList().removeLast();
            }
            SelectVariation.this.getEditableNodeList().addLast(last);
            SelectVariation.this.targetNode_.setSelectedVariationIndex(SelectVariation.this.newVariationIndex_);
            GameTree target = SelectVariation.this.targetNode_.getNodeTree().getGameTree();
            SelectVariation.this.getEditableNodeList().addLast(target.getChild(SelectVariation.this.newVariationIndex_));
        }

        public void undo() {
            if (!$assertionsDisabled && !SelectVariation.this.targetNode_.getNodeTree().isChildrenStyle()) {
                throw new AssertionError((Object)"Sibling style must not user this class.");
            }
            super.undo();
            SelectVariation.this.targetNode_.setSelectedVariationIndex(SelectVariation.this.lastIndex_);
            NodeEntity last = SelectVariation.this.getEditableNodeList().removeLast();
            while (!last.equals(SelectVariation.this.targetNode_)) {
                last = SelectVariation.this.getEditableNodeList().removeLast();
            }
            SelectVariation.this.getEditableNodeList().addLast(last);
            SelectVariation.this.getEditableNodeList().addLast(SelectVariation.this.removedChain_.toArray(new NodeEntity[SelectVariation.this.removedChain_.size()]));
            SelectVariation.this.removedChain_ = null;
        }
    }

    private class SelectVariationAsSibling
    extends AbstractCommand {
        private NodeEntity unchangedLastNode_;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            $assertionsDisabled = !SelectVariationAsSibling.class.desiredAssertionStatus();
        }

        public void execute() {
            if (!$assertionsDisabled && SelectVariation.this.targetNode_.getNodeTree().isChildrenStyle()) {
                throw new AssertionError((Object)"Children style must not user this class.");
            }
            super.execute();
            SelectVariation.this.removedChain_ = new LinkedList();
            NodeEntity last = SelectVariation.this.getEditableNodeList().removeLast();
            while (!last.equals(SelectVariation.this.targetNode_)) {
                SelectVariation.this.removedChain_.addFirst(last);
                if (SelectVariation.this.getEditableNodeList().size() == 0) break;
                last = SelectVariation.this.getEditableNodeList().removeLast();
            }
            int lastIndex = SelectVariation.this.getEditableNodeList().size();
            this.unchangedLastNode_ = lastIndex != 0 ? SelectVariation.this.getEditableNodeList().getLast() : null;
            GameTree target = SelectVariation.this.targetNode_.getNodeTree().getParentGameTree();
            SelectVariation.this.getEditableNodeList().addLast(target.getChild(SelectVariation.this.newVariationIndex_));
            SelectVariation.this.getEditableNodeList().get(lastIndex).setSelectedVariationIndex(SelectVariation.this.newVariationIndex_);
        }

        public void undo() {
            if (!$assertionsDisabled && SelectVariation.this.targetNode_.getNodeTree().isChildrenStyle()) {
                throw new AssertionError((Object)"Children style must not user this class.");
            }
            super.undo();
            NodeEntity last = SelectVariation.this.getEditableNodeList().removeLast();
            while (!last.equals(this.unchangedLastNode_)) {
                if (SelectVariation.this.getEditableNodeList().size() == 0) break;
                last = SelectVariation.this.getEditableNodeList().removeLast();
            }
            if (this.unchangedLastNode_ != null) {
                SelectVariation.this.getEditableNodeList().addLast(this.unchangedLastNode_);
            }
            SelectVariation.this.targetNode_.setSelectedVariationIndex(SelectVariation.this.lastIndex_);
            SelectVariation.this.getEditableNodeList().addLast(SelectVariation.this.targetNode_);
            SelectVariation.this.getEditableNodeList().addLast(SelectVariation.this.removedChain_.toArray(new NodeEntity[SelectVariation.this.removedChain_.size()]));
            SelectVariation.this.removedChain_ = null;
            this.unchangedLastNode_ = null;
        }
    }
}

