/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model.cmd;

import java.util.EnumSet;
import org.unitarou.cmd.Command;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.cmd.RemoveNode;
import org.unitarou.yukinoshita.model.EditableNodeList;
import org.unitarou.yukinoshita.model.NodeEntity;
import org.unitarou.yukinoshita.model.cmd.Command4NodeList;
import org.unitarou.yukinoshita.model.cmd.ModelInfluence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveCurrentNode
extends Command4NodeList {
    private static final MessageResource LB_NAME = new MessageResource(RemoveCurrentNode.class, "lbName");
    private Command sgfCommand_ = null;
    static /* synthetic */ Class class$0;

    @Override
    protected boolean setup() {
        if (this.sgfCommand_ != null) {
            return true;
        }
        EditableNodeList nodeList = this.getEditableNodeList();
        if (nodeList == null) {
            return false;
        }
        NodeEntity nodeEntity = nodeList.getPosition();
        this.sgfCommand_ = new RemoveNode(nodeEntity.getNodeTree().getGameTree(), nodeEntity.getNode());
        this.setDisplayName(LB_NAME.get());
        this.setExecutedNodeIndex(nodeList.getPositionIndex() - 1);
        this.setUndoneNodeIndex(nodeList.getPositionIndex());
        return true;
    }

    @Override
    public void execute() {
        super.execute();
        this.sgfCommand_.execute();
        EditableNodeList nodeList = this.getEditableNodeList();
        nodeList.setPositionIndex(this.getExecutedNodeIndex());
        NodeEntity entity = nodeList.getPosition();
        while (entity != nodeList.removeLast()) {
        }
        nodeList.addLast(entity);
        GameTree gameTree = entity.getNodeTree().getGameTree();
        boolean found = false;
        for (Node node : gameTree.getSequence()) {
            if (node == entity.getNode()) {
                found = true;
                continue;
            }
            if (!found) continue;
            this.getEditableNodeList().addLast(node, gameTree);
        }
        if (gameTree.getChildrenSize() != 0) {
            this.getEditableNodeList().addLast(gameTree.getChild(0));
        }
    }

    @Override
    public void undo() {
        super.undo();
        this.sgfCommand_.undo();
        EditableNodeList nodeList = this.getEditableNodeList();
        nodeList.setPositionIndex(this.getExecutedNodeIndex());
        NodeEntity entity = nodeList.getPosition();
        while (entity != nodeList.removeLast()) {
        }
        GameTree gameTree = entity.getNodeTree().getGameTree();
        boolean found = false;
        for (Node node : gameTree.getSequence()) {
            if (node == entity.getNode()) {
                found = true;
            }
            if (!found) continue;
            this.getEditableNodeList().addLast(node, gameTree);
        }
        if (gameTree.getChildrenSize() != 0) {
            this.getEditableNodeList().addLast(gameTree.getChild(0));
        }
    }

    @Override
    public EnumSet<ModelInfluence> getInfluence() {
        return EnumSet.of(ModelInfluence.NODE_DOWNWARD, ModelInfluence.NODE_CURRENT);
    }
}

