/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model.board;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.unitarou.lang.NullArgumentException;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.util.BasicFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StoneGroupImpl {
    private final SgfSize size_;
    private final Set<SgfPoint> stones_;
    private final Set<SgfPoint> neighbors_;
    private final Set<SgfPoint> lifePoints_;

    StoneGroupImpl(SgfSize size) {
        assert (size != null);
        this.size_ = size;
        this.stones_ = new TreeSet<SgfPoint>();
        this.neighbors_ = new TreeSet<SgfPoint>();
        this.lifePoints_ = new TreeSet<SgfPoint>();
    }

    public StoneGroupImpl(StoneGroupImpl src) {
        if (src == null) {
            throw new NullArgumentException();
        }
        this.size_ = src.size_;
        this.stones_ = new TreeSet<SgfPoint>(src.stones_);
        this.neighbors_ = new TreeSet<SgfPoint>(src.neighbors_);
        this.lifePoints_ = new TreeSet<SgfPoint>(src.lifePoints_);
    }

    boolean add(SgfPoint point, Collection<SgfPoint> lifePoints) {
        assert (point != null && lifePoints != null);
        if (!this.size_.equals(point.size())) {
            throw new IllegalArgumentException("Bad size " + this.size_ + "!=" + point.size());
        }
        if (!this.lifePoints_.contains(point) && !this.lifePoints_.isEmpty()) {
            return false;
        }
        this.stones_.add(point);
        for (SgfPoint neighbor : point.neighbors()) {
            if (this.stones_.contains(neighbor)) continue;
            this.neighbors_.add(neighbor);
        }
        this.lifePoints_.remove(point);
        for (SgfPoint lifePoint : lifePoints) {
            if (this.stones_.contains(lifePoint)) {
                throw new IllegalArgumentException(lifePoint + " does not touch this group" + BasicFormatter.format(this.stones_));
            }
            this.lifePoints_.add(lifePoint);
        }
        return true;
    }

    void add(StoneGroupImpl src) {
        assert (src != null);
        this.stones_.addAll(src.stones_);
        this.neighbors_.addAll(src.neighbors_);
        this.lifePoints_.addAll(src.lifePoints_);
        Iterator<SgfPoint> ip = this.stones_.iterator();
        while (ip.hasNext()) {
            this.lifePoints_.remove(ip.next());
        }
    }

    StoneGroupImpl[] remove(SgfPoint point) {
        assert (point != null && this.stones_.contains(point));
        this.stones_.remove(point);
        this.lifePoints_.add(point);
        for (SgfPoint neighbor : point.neighbors()) {
            if (!this.lifePoints_.contains(neighbor)) continue;
            boolean noContact = true;
            Iterator jp = neighbor.neighbors().iterator();
            while (jp.hasNext()) {
                if (!this.stones_.contains(jp.next())) continue;
                noContact = false;
                break;
            }
            if (!noContact) continue;
            this.lifePoints_.remove(neighbor);
        }
        this.neighbors_.clear();
        for (SgfPoint point2 : this.stones_) {
            this.neighbors_.addAll(point2.neighbors());
        }
        HashSet<StoneGroupImpl> implSet = new HashSet<StoneGroupImpl>();
        for (SgfPoint point2 : this.stones_) {
            boolean exists = false;
            for (StoneGroupImpl impl : implSet) {
                if (!impl.stones_.contains(point2)) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            StoneGroupImpl impl = new StoneGroupImpl(this.size_);
            impl.trace(point2, this);
            implSet.add(impl);
        }
        if (implSet.isEmpty()) {
            this.neighbors_.clear();
            this.lifePoints_.clear();
            implSet.add(this);
        }
        return implSet.toArray(new StoneGroupImpl[implSet.size()]);
    }

    private void trace(SgfPoint point, StoneGroupImpl mother) {
        this.stones_.add(point);
        for (SgfPoint point2 : point.neighbors()) {
            if (mother.lifePoints_.contains(point2)) {
                this.lifePoints_.add(point2);
            }
            if (this.stones_.contains(point2)) continue;
            this.neighbors_.add(point2);
            if (!mother.stones_.contains(point2)) continue;
            this.trace(point2, mother);
        }
    }

    void addLifePoint(SgfPoint point) {
        assert (point != null);
        this.lifePoints_.add(point);
    }

    boolean removeLifePoint(SgfPoint point) {
        assert (point != null);
        if (this.lifePoints_.remove(point)) {
            return this.lifePoints_.isEmpty();
        }
        return false;
    }

    Set<SgfPoint> stones() {
        return Collections.unmodifiableSet(this.stones_);
    }

    int count() {
        return this.stones_.size();
    }

    int countLifePoint() {
        return this.lifePoints_.size();
    }

    boolean contains(SgfPoint point) {
        return this.stones_.contains(point);
    }

    boolean isNeighbor(SgfPoint point) {
        return this.neighbors_.contains(point);
    }

    boolean isLifePoint(SgfPoint point) {
        return this.lifePoints_.contains(point);
    }
}

