/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model.board;

import java.util.Collection;
import java.util.Set;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.model.board.StoneGroupImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StoneGroup
implements Comparable {
    private StoneGroupImpl impl_;

    public StoneGroup(SgfSize size) {
        ArgumentChecker.throwIfNull((Object)size);
        this.impl_ = new StoneGroupImpl(size);
    }

    public StoneGroup(StoneGroup src) {
        ArgumentChecker.throwIfNull((Object)src);
        this.impl_ = new StoneGroupImpl(src.impl_);
    }

    private StoneGroup(StoneGroupImpl impl) {
        assert (impl != null);
        this.impl_ = new StoneGroupImpl(impl);
    }

    public boolean add(SgfPoint point, Collection<SgfPoint> lifePoints) {
        ArgumentChecker.throwIfNull((Object)point, lifePoints);
        return this.impl_.add(point, lifePoints);
    }

    public void add(StoneGroup src) {
        ArgumentChecker.throwIfNull((Object)src);
        this.impl_.add(src.impl_);
    }

    public StoneGroup[] remove(SgfPoint point) {
        ArgumentChecker.throwIfNull((Object)point);
        if (!this.impl_.contains(point)) {
            throw new IllegalArgumentException();
        }
        StoneGroupImpl[] impls = this.impl_.remove(point);
        this.impl_ = impls[0];
        StoneGroup[] groups = new StoneGroup[impls.length];
        groups[0] = this;
        int i = 1;
        while (i < impls.length) {
            groups[i] = new StoneGroup(impls[i]);
            ++i;
        }
        return groups;
    }

    public void addLifePoint(SgfPoint point) {
        ArgumentChecker.throwIfNull((Object)point);
        if (this.impl_.isNeighbor(point)) {
            this.impl_.addLifePoint(point);
        }
    }

    public boolean removeLifePoint(SgfPoint point) {
        ArgumentChecker.throwIfNull((Object)point);
        if (this.impl_.isLifePoint(point)) {
            return this.impl_.removeLifePoint(point);
        }
        return false;
    }

    public Set<SgfPoint> stones() {
        return this.impl_.stones();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() == this.getClass()) {
            return false;
        }
        return this.impl_.equals(((StoneGroup)obj).impl_);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public int compareTo(Object o) {
        StoneGroup des = (StoneGroup)o;
        return System.identityHashCode(this.impl_) - System.identityHashCode(des.impl_);
    }

    public int count() {
        return this.impl_.count();
    }

    public int countLifePoint() {
        return this.impl_.countLifePoint();
    }

    public boolean contains(SgfPoint point) {
        return this.impl_.contains(point);
    }

    public boolean isLifePoint(SgfPoint point) {
        return this.impl_.isLifePoint(point);
    }
}

