/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.unitarou.cmd.Command;
import org.unitarou.cmd.CommandDriver;
import org.unitarou.cmd.CommandDriverListener;
import org.unitarou.sgf.PropertyType;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.util.BasicFinder;
import org.unitarou.sgf.util.provider.crdlp.CoordinatesLabelProvider;
import org.unitarou.sgf.util.provider.crdlp.NoCoordinatesProvider;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.context.Context;
import org.unitarou.yukinoshita.context.CurrentContext;
import org.unitarou.yukinoshita.model.EditableNodeList;
import org.unitarou.yukinoshita.model.NodeEntity;
import org.unitarou.yukinoshita.model.NodeList;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.cmd.Command4NodeList;
import org.unitarou.yukinoshita.model.cmd.SelectVariation;
import org.unitarou.yukinoshita.model.cmd.StartSolvingProblem;
import org.unitarou.yukinoshita.view.provider.vlp.NoVariationProvider;
import org.unitarou.yukinoshita.view.provider.vlp.VariationLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GameMediator {
    private final RootGameTree root_;
    private final EditableNodeList nodeList_;
    private final CommandDriver commandDriver_;
    private int changedCounter_;
    private boolean isSolvingProblem_;
    private final Map<String, Object> sidetrackContextMap_;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public GameMediator(RootGameTree root) {
        this(root, false);
    }

    public GameMediator(RootGameTree root, boolean defaultChanged) {
        ArgumentChecker.throwIfNull((Object)root);
        this.root_ = root;
        this.nodeList_ = new EditableNodeList(this.root_);
        this.commandDriver_ = new CommandDriver();
        this.commandDriver_.addListener(new ChangeListener());
        this.sidetrackContextMap_ = new HashMap<String, Object>();
        this.initializeByGameType();
        this.changedCounter_ = defaultChanged ? 1 : 0;
    }

    private void initializeByGameType() {
        this.isSolvingProblem_ = false;
        this.nodeList_.setPositionIndex(this.nodeList_.size() - 1);
        String datum = BasicFinder.findDatum(this.root_.getSequence(), SgfId.GAME_TYPE);
        if (datum.equals(GameType.PROBLEM.getString())) {
            this.startSolvingProblem();
        }
    }

    public RootGameTree getRootGameTree() {
        return this.root_;
    }

    public CommandDriver.Status executeCommand(Command4NodeList command) {
        ArgumentChecker.throwIfNull((Object)command);
        EditableNodeList editableNodeList = command.getEditableNodeList();
        if (editableNodeList != null && this.nodeList_ != editableNodeList) {
            throw new IllegalArgumentException("Bad match of EditableNodeList");
        }
        command.setEditableNodeList(this.nodeList_);
        return this.commandDriver_.execute(command);
    }

    public CommandDriver.Status undo() {
        return this.commandDriver_.undo();
    }

    public CommandDriver.Status redo() {
        return this.commandDriver_.redo();
    }

    public CommandDriver.Status getCommandDriverStatus() {
        return this.commandDriver_.getStatus();
    }

    public NodeList getNodeList() {
        return this.nodeList_;
    }

    public NodeView getCurrentNodeView() {
        return this.nodeList_.getNodeView(this.nodeList_.getPositionIndex());
    }

    public int getCurrentNodeIndex() {
        return this.nodeList_.getPositionIndex();
    }

    public int findNodeView(PropertyType propertyType) {
        int index = this.getCurrentNodeIndex();
        NodeView target = this.nodeList_.getNodeView(0);
        while (index >= 0) {
            target = this.nodeList_.getNodeView(index);
            if (target.containsPropertyType(propertyType)) break;
            --index;
        }
        return index;
    }

    public void setNodeIndex(int index) {
        this.nodeList_.setPositionIndex(index);
    }

    public NodeView setNodeIndexDelta(int delta) {
        int newIndex = this.nodeList_.getPositionIndex();
        if ((newIndex += delta) < 0) {
            newIndex = 0;
        } else if (this.nodeList_.size() <= newIndex) {
            newIndex = this.nodeList_.size() - 1;
        }
        this.nodeList_.setPositionIndex(newIndex);
        return this.getCurrentNodeView();
    }

    public GameType getGameType() {
        return this.root_.getGameType();
    }

    public boolean isChanged() {
        return this.changedCounter_ != 0;
    }

    public void clearChanged() {
        this.changedCounter_ = 0;
    }

    public void startSolvingProblem() {
        if (this.isSolvingProblem_) {
            this.finishSolvingProblem();
        }
        this.storeContextForSolvingProblem();
        this.isSolvingProblem_ = true;
        StartSolvingProblem command = new StartSolvingProblem(this);
        this.commandDriver_.execute(command);
    }

    private void storeContextForSolvingProblem() {
        Context context = Yukinoshita.context();
        this.sidetrackContextMap_.clear();
        this.sidetrackContextMap_.put(Context.SHOW_LAST_MOVE_MARK.id(), context.getAttribute(Context.SHOW_LAST_MOVE_MARK.id(), this.root_));
        this.sidetrackContextMap_.put(VariationLabelProvider.class.getName(), context.getProvider(VariationLabelProvider.class, this.root_));
        this.sidetrackContextMap_.put(CoordinatesLabelProvider.class.getName(), context.getProvider(CoordinatesLabelProvider.class, this.root_));
        context.setAttribute(Context.SHOW_LAST_MOVE_MARK.id(), Boolean.FALSE, this.root_);
        context.setProvider(VariationLabelProvider.class, NoVariationProvider.class, this.root_);
        context.setProvider(CoordinatesLabelProvider.class, NoCoordinatesProvider.class, this.root_);
        Set<String> keyset = this.sidetrackContextMap_.keySet();
        context.fireAttributeChanged(keyset.toArray(new String[keyset.size()]));
    }

    public void finishSolvingProblem() {
        if (!this.isSolvingProblem_) {
            return;
        }
        Command firstCommand = null;
        while (this.commandDriver_.getStatus().isUndoable()) {
            CommandDriver.Status status = this.commandDriver_.undo();
            Command command = status.getExecutedCommand();
            if (firstCommand == null) {
                firstCommand = command;
            }
            if (!(command instanceof StartSolvingProblem)) continue;
            this.isSolvingProblem_ = false;
            this.commandDriver_.clearRedo();
            this.restoreContextBySolvingProblem();
            return;
        }
        if (firstCommand != null) {
            while (firstCommand != this.commandDriver_.redo()) {
            }
        }
        this.isSolvingProblem_ = false;
        this.restoreContextBySolvingProblem();
        throw new IllegalStateException("Can't find StartSolvingProblem command.");
    }

    private void restoreContextBySolvingProblem() {
        Context context = Yukinoshita.context();
        for (Map.Entry<String, Object> entry : this.sidetrackContextMap_.entrySet()) {
            context.setAttribute(entry.getKey(), entry.getValue(), this.root_);
        }
        Set<String> keyset = this.sidetrackContextMap_.keySet();
        context.fireAttributeChanged(keyset.toArray(new String[keyset.size()]));
    }

    public SgfPoint[] findInvalidPoints() {
        CommandDriver driver4Validate = new CommandDriver();
        Set<SgfPoint> invalidPoint = this.validatePoint(this.nodeList_, this.nodeList_.getPositionIndex(), driver4Validate);
        while (driver4Validate.getStatus().isUndoable()) {
            driver4Validate.undo();
        }
        return invalidPoint.toArray(new SgfPoint[invalidPoint.size()]);
    }

    private Set<SgfPoint> validatePoint(EditableNodeList nodeList, int nodeIndex, CommandDriver driver4Validate) {
        HashSet<SgfPoint> invalidPoint = new HashSet<SgfPoint>();
        while (nodeIndex < nodeList.size()) {
            nodeList.setPositionIndex(nodeIndex);
            NodeEntity entity = nodeList.getPosition();
            invalidPoint.addAll(entity.getIgoBoard().validate());
            if (entity.getNodeTree().getVariationSize() == 0) {
                ++nodeIndex;
                continue;
            }
            int nextNodeIndex = nodeIndex + 1;
            invalidPoint.addAll(this.validatePoint(nodeList, nextNodeIndex, driver4Validate));
            int i = 1;
            while (i < entity.getNodeTree().getVariationSize()) {
                nodeList.setPositionIndex(nodeIndex);
                SelectVariation command = new SelectVariation(i);
                command.setEditableNodeList(nodeList);
                driver4Validate.execute(command);
                invalidPoint.addAll(this.validatePoint(nodeList, nextNodeIndex, driver4Validate));
                ++i;
            }
            break block0;
        }
        return invalidPoint;
    }

    public CurrentContext getContext() {
        return Yukinoshita.context().getCurrent(this.root_);
    }

    private class ChangeListener
    implements CommandDriverListener {
        private final Set<Class<? extends Command4NodeList>> ignoreCommandSet_ = new HashSet<Class<? extends Command4NodeList>>();
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;

        public ChangeListener() {
            this.ignoreCommandSet_.add(SelectVariation.class);
            this.ignoreCommandSet_.add(StartSolvingProblem.class);
        }

        private boolean isChangedCommand(Command command) {
            return !GameMediator.this.isSolvingProblem_ && !this.ignoreCommandSet_.contains(command.getClass());
        }

        public void undoExecuted(Command command) {
            if (this.isChangedCommand(command)) {
                GameMediator gameMediator = GameMediator.this;
                gameMediator.changedCounter_ = gameMediator.changedCounter_ - 1;
            }
            if (command instanceof Command4NodeList) {
                GameMediator.this.nodeList_.setPositionIndex(((Command4NodeList)command).getUndoneNodeIndex());
            } else {
                GameMediator.this.nodeList_.setPositionIndex(0);
            }
        }

        public void executed(Command command) {
            if (this.isChangedCommand(command)) {
                GameMediator gameMediator = GameMediator.this;
                gameMediator.changedCounter_ = gameMediator.changedCounter_ + 1;
            }
            if (command instanceof Command4NodeList) {
                GameMediator.this.nodeList_.setPositionIndex(((Command4NodeList)command).getExecutedNodeIndex());
            } else {
                GameMediator.this.nodeList_.setPositionIndex(0);
            }
        }

        public void redoExecuted(Command command) {
            if (this.isChangedCommand(command)) {
                GameMediator gameMediator = GameMediator.this;
                gameMediator.changedCounter_ = gameMediator.changedCounter_ + 1;
            }
            if (command instanceof Command4NodeList) {
                GameMediator.this.nodeList_.setPositionIndex(((Command4NodeList)command).getExecutedNodeIndex());
            } else {
                GameMediator.this.nodeList_.setPositionIndex(0);
            }
        }
    }
}

