/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.CollectionEvent;
import org.unitarou.sgf.CollectionListener;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.type.GameType;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.model.GameMediator;

public class CollectionEditor {
    private static final Log logger_s_ = LogFactory.getLog(CollectionEditor.class);
    private final Collection collection_;
    private final CollectionListener listener_;
    private final Map<Integer, GameMediator> gameMap_;
    private int activeGameIndex_;
    static /* synthetic */ Class class$0;

    public CollectionEditor(Collection collection) {
        this(collection, false);
    }

    public CollectionEditor(Collection collection, boolean setChangedFlag) {
        ArgumentChecker.throwIfNull((Object)collection);
        this.collection_ = collection;
        this.listener_ = new CollectionListenerImpl();
        collection.addListener(this.listener_);
        this.gameMap_ = new HashMap<Integer, GameMediator>(this.collection_.size());
        this.activeGameIndex_ = 0;
        if (setChangedFlag) {
            int i = 0;
            while (i < this.collection_.size()) {
                this.initializeGame(i, true);
                ++i;
            }
        }
    }

    public void dispose() {
        this.gameMap_.clear();
        this.collection_.removeListener(this.listener_);
    }

    protected void finalize() throws Throwable {
        try {
            if (!this.gameMap_.isEmpty()) {
                logger_s_.warn(this + " is not disposed.");
                this.dispose();
            }
        }
        finally {
            super.finalize();
        }
    }

    public void setActiveGame(int gameIndex) {
        if (gameIndex < 0 || this.collection_.size() <= gameIndex) {
            throw new IllegalArgumentException("Parameter gameIndex is out of bounds. Game size is " + this.collection_.size() + ". Parameter gameIndex is " + gameIndex);
        }
        this.activeGameIndex_ = gameIndex;
    }

    public Collection getCollection() {
        return this.collection_;
    }

    public int getActiveGameIndex() {
        return this.activeGameIndex_;
    }

    public GameMediator getActiveGame() {
        return this.get(this.activeGameIndex_);
    }

    private GameMediator initializeGame(int index, boolean setChangedFlag) {
        RootGameTree rootGameTree = this.collection_.get(index);
        GameMediator ret = new GameMediator(rootGameTree, setChangedFlag);
        this.gameMap_.put(new Integer(index), ret);
        return ret;
    }

    public boolean[] getChangedFlags() {
        boolean[] ret = new boolean[this.collection_.size()];
        int i = 0;
        while (i < ret.length) {
            GameMediator gm = this.gameMap_.get(new Integer(i));
            ret[i] = gm != null && gm.isChanged();
            ++i;
        }
        return ret;
    }

    public void clearChangedFlags() {
        for (GameMediator mediator : this.gameMap_.values()) {
            mediator.clearChanged();
        }
    }

    public int size() {
        return this.collection_.size();
    }

    public GameMediator createGame(RootGameTree rgt) {
        ArgumentChecker.throwIfNull((Object)rgt);
        this.collection_.addLast(rgt);
        GameMediator gm = this.initializeGame(this.collection_.size() - 1, true);
        return gm;
    }

    public boolean isDrill() {
        return this.get(0).getGameType().equals(GameType.DRILL);
    }

    private GameMediator get(int index) {
        if (index < 0 || this.collection_.size() <= index) {
            throw new IndexOutOfBoundsException("Bad index:" + index);
        }
        GameMediator ret = this.gameMap_.get(new Integer(index));
        if (ret == null) {
            ret = this.initializeGame(index, false);
        }
        return ret;
    }

    public void remove(int index) {
        if (index < 0 || this.collection_.size() <= index) {
            throw new IndexOutOfBoundsException("Bad index:" + index);
        }
        this.collection_.remove(this.collection_.get(index));
    }

    private class CollectionListenerImpl
    implements CollectionListener {
        CollectionListenerImpl() {
        }

        public void rootGameTreeRemoved(CollectionEvent event) {
            RootGameTree target = event.getRootGameTree();
            for (Map.Entry entry : CollectionEditor.this.gameMap_.entrySet()) {
                if (!((GameMediator)entry.getValue()).getRootGameTree().equals(target)) continue;
                CollectionEditor.this.gameMap_.remove(entry.getKey());
                if (CollectionEditor.this.activeGameIndex_ == CollectionEditor.this.collection_.size()) {
                    CollectionEditor.this.activeGameIndex_ = CollectionEditor.this.collection_.size() - 1;
                }
                return;
            }
        }
    }
}

