/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.events;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.lang.Classes;
import org.unitarou.lang.Runtimes;
import org.unitarou.sgf.type.GameType;
import org.unitarou.util.Adaptable;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.events.ActionListener;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.HandlerSelector;
import org.unitarou.yukinoshita.events.StateHandler;
import org.unitarou.yukinoshita.model.cmd.Command4NodeList;
import org.unitarou.yukinoshita.view.cmd.Command4View;
import org.unitarou.yukinoshita.view.monitor.CollectionMonitor;
import org.unitarou.yukinoshita.view.monitor.CommandDriverMonitor;
import org.unitarou.yukinoshita.view.monitor.ContextMonitor;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;
import org.unitarou.yukinoshita.view.monitor.GameInfoNodeMonitor;
import org.unitarou.yukinoshita.view.monitor.GameMonitor;
import org.unitarou.yukinoshita.view.monitor.LayoutMonitor;
import org.unitarou.yukinoshita.view.monitor.NodeListMonitor;
import org.unitarou.yukinoshita.view.monitor.NodeMonitor;
import org.unitarou.yukinoshita.view.monitor.OutlineMonitor;
import org.unitarou.yukinoshita.view.monitor.ProblemStatusMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventBrokerImpl
implements EventBroker {
    private static final Log log_s_ = LogFactory.getLog(EventBrokerImpl.class);
    private static final Class[] viewAdapters_s_ = new Class[]{CollectionMonitor.class, GameMonitor.class, NodeListMonitor.class, NodeMonitor.class, GameInfoNodeMonitor.class, ContextMonitor.class, ControllerStatusMonitor.class, ProblemStatusMonitor.class, OutlineMonitor.class, LayoutMonitor.class, CommandDriverMonitor.class};
    private static final Class[] ctrlAdapters_s_ = new Class[]{ActionListener.class};
    private final Map<Class<?>, Set<Object>> adapterMap_ = new HashMap();
    private final HandlerSelector handlerSelector_ = new HandlerSelector();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;

    public EventBrokerImpl() {
        this.handlerSelector_.setEventBroker(this);
    }

    public void dispose() {
        for (Set<Object> set : this.adapterMap_.values()) {
            set.clear();
        }
        this.adapterMap_.clear();
        this.handlerSelector_.clear();
    }

    @Override
    public void addView(Adaptable view) {
        ArgumentChecker.throwIfNull((Object)view);
        int i = 0;
        while (i < viewAdapters_s_.length) {
            this.addAdapter(view, viewAdapters_s_[i]);
            ++i;
        }
    }

    @Override
    public void removeView(Adaptable view) {
        ArgumentChecker.throwIfNull((Object)view);
        int i = 0;
        while (i < viewAdapters_s_.length) {
            this.removeAdapter(view, viewAdapters_s_[i]);
            ++i;
        }
    }

    public void addController(Adaptable ctrl) {
        ArgumentChecker.throwIfNull((Object)ctrl);
        int i = 0;
        while (i < ctrlAdapters_s_.length) {
            this.addAdapter(ctrl, ctrlAdapters_s_[i]);
            ++i;
        }
    }

    public void removeController(Adaptable ctrl) {
        ArgumentChecker.throwIfNull((Object)ctrl);
        int i = 0;
        while (i < ctrlAdapters_s_.length) {
            this.removeAdapter(ctrl, ctrlAdapters_s_[i]);
            ++i;
        }
    }

    private void addAdapter(Adaptable adaptable, Class<?> clazz) {
        Object obj = adaptable.getAdapter(clazz);
        if (obj == null) {
            return;
        }
        if (!clazz.isInstance(obj)) {
            throw new IllegalArgumentException("Bad adapter: adaptable:" + adaptable + " class:" + clazz + ", but obj:" + obj);
        }
        Set<Object> set = this.adapterMap_.get(clazz);
        if (set == null) {
            set = new HashSet<Object>();
            this.adapterMap_.put(clazz, set);
        }
        set.add(obj);
        if (log_s_.isTraceEnabled()) {
            log_s_.trace("[ADD ADAPTER] " + Classes.simpleName(adaptable.getClass()) + " has " + Classes.simpleName(clazz) + "'s adapter: " + obj);
        }
    }

    private void removeAdapter(Adaptable adaptable, Class<?> clazz) {
        Object obj = adaptable.getAdapter(clazz);
        if (obj == null) {
            return;
        }
        if (!clazz.isInstance(obj)) {
            throw new IllegalArgumentException("Bad adapter: adaptable:" + adaptable + " class:" + clazz + ", but obj:" + obj);
        }
        Set<Object> set = this.adapterMap_.get(clazz);
        if (set != null) {
            set.remove(obj);
        }
        if (log_s_.isTraceEnabled()) {
            log_s_.trace("[DEL ADAPTER] " + Classes.simpleName(adaptable.getClass()) + " has " + Classes.simpleName(clazz) + "'s adapter: " + obj);
        }
    }

    @Override
    public <T> Set<T> getListeners(Class<T> clazz) {
        ArgumentChecker.throwIfNull(clazz);
        Set<Object> set = this.adapterMap_.get(clazz);
        if (set == null) {
            set = new HashSet<Object>();
            log_s_.warn("Unused or unregistered listener (May be BUG):" + clazz);
        }
        HashSet<Object> ret = new HashSet<Object>(set.size());
        for (Object object : set) {
            ret.add(object);
        }
        if (log_s_.isTraceEnabled()) {
            log_s_.trace("[CALL LISTENER] " + clazz.getName() + " is called. " + "Listener size is " + ret.size());
        }
        return ret;
    }

    @Override
    public void register(GameType gameType, boolean isEditMode, StateHandler stateHandler) {
        this.handlerSelector_.put(gameType, isEditMode, stateHandler);
        stateHandler.setEventBroker(this);
        if (log_s_.isTraceEnabled()) {
            log_s_.trace("[REGISTER] " + gameType + "(Edit mode:" + isEditMode + "), state handler: " + stateHandler);
        }
    }

    @Override
    public void connect(GameType gameType, boolean isEditMode) {
        this.handlerSelector_.connect(gameType, isEditMode);
        if (log_s_.isTraceEnabled()) {
            log_s_.trace("[CONNECT] " + gameType + "/Edit mode:" + isEditMode);
        }
    }

    @Override
    public void disconnect() {
        this.handlerSelector_.disconnect();
        if (log_s_.isTraceEnabled()) {
            log_s_.trace("[DISCONNECT] ");
        }
    }

    @Override
    public StateHandler getCurrentStateHander() {
        return this.handlerSelector_.getCurrent();
    }

    @Override
    public void executeCommand(Command4NodeList command) {
        ArgumentChecker.throwIfNull((Object)command);
        if (log_s_.isTraceEnabled()) {
            log_s_.trace("[START COMMAND] " + command + " " + Runtimes.formatStackTrace(4));
        }
        for (ActionListener listener : this.getListeners(ActionListener.class)) {
            listener.executeCommand(command);
        }
        if (log_s_.isTraceEnabled()) {
            log_s_.trace("[END COMMAND] " + command);
        }
    }

    @Override
    public void executeCommand(Command4View command) {
        ArgumentChecker.throwIfNull((Object)command);
        if (log_s_.isTraceEnabled()) {
            log_s_.trace("[START COMMAND] " + command + " " + Runtimes.formatStackTrace(4));
        }
        for (ActionListener listener : this.getListeners(ActionListener.class)) {
            listener.executeCommand(command);
        }
        if (log_s_.isTraceEnabled()) {
            log_s_.trace("[END COMMAND] " + command);
        }
    }
}

