/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.context;

import java.io.File;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.util.Provider;
import org.unitarou.util.StrategyRegistrar;
import org.unitarou.util.WeakedList;
import org.unitarou.yukinoshita.context.BooleanContextValue;
import org.unitarou.yukinoshita.context.Context;
import org.unitarou.yukinoshita.context.ContextListener;
import org.unitarou.yukinoshita.context.ContextValue;
import org.unitarou.yukinoshita.context.CurrentContext;
import org.unitarou.yukinoshita.context.FileContextValue;
import org.unitarou.yukinoshita.context.IntArrayContextValue;
import org.unitarou.yukinoshita.context.IntContextValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultContext
implements Context {
    private final Object rootScope_ = new Object();
    private final StrategyRegistrar strategyRegistrar_ = new StrategyRegistrar();
    private final WeakHashMap<Object, Object> scopeMap_ = new WeakHashMap();
    private final WeakHashMap<Object, Map<String, Object>> attributeMap_ = new WeakHashMap();
    private final WeakHashMap<Object, CurrentContext> contextMap_;
    private final WeakedList<ContextListener> listeners_;
    static /* synthetic */ Class class$0;

    public DefaultContext() {
        this.attributeMap_.put(this.rootScope_, new HashMap());
        this.contextMap_ = new WeakHashMap();
        this.listeners_ = new WeakedList();
    }

    public boolean registerInterface(Class provider) {
        ArgumentChecker.throwIfNull((Object)provider);
        return this.strategyRegistrar_.registerStrategy(provider);
    }

    @Override
    public Class<?>[] getInterfaces() {
        return this.strategyRegistrar_.getStrategies();
    }

    @Override
    public Class<?>[] registerProvider(Class<?> concreteProvider) {
        Class<?>[] providers;
        ArgumentChecker.throwIfNull(concreteProvider);
        Class<?>[] classArray = providers = this.strategyRegistrar_.registerConcreteStrategy(concreteProvider);
        int n = 0;
        int n2 = classArray.length;
        while (n < n2) {
            Class<?> clazz = classArray[n];
            this.getProvider(clazz, null);
            ++n;
        }
        return providers;
    }

    @Override
    public void loadContext() {
    }

    @Override
    public void saveContext() {
    }

    @Override
    public void setProvider(Class<?> providerInterface, Class<?> provider, Object scope) {
        ArgumentChecker.throwIfNull(providerInterface, provider);
        if (!providerInterface.isAssignableFrom(provider)) {
            throw new IllegalArgumentException("Interface mismatch: " + providerInterface + " is no assignable from " + provider);
        }
        Class<?>[] providers = this.strategyRegistrar_.getConcreteStrategies(providerInterface);
        int i = 0;
        while (i < providers.length) {
            if (providers[i].equals(provider)) {
                this.setProviderImpl(providerInterface, provider, scope);
                return;
            }
            ++i;
        }
        this.setProviderImpl(providerInterface, provider, scope);
    }

    private void setProviderImpl(Class providerInterface, Class provider, Object scope) {
        try {
            this.setAttribute(providerInterface.getName(), provider.newInstance(), scope);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Instantiation failure:" + provider);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Constructer access failure:" + provider);
        }
    }

    @Override
    public <T extends Provider> T[] getProviders(Class<T> provider) {
        ArgumentChecker.throwIfNull(provider);
        return (Provider[])this.strategyRegistrar_.getConcreteStrategyInstances(provider);
    }

    @Override
    public <T extends Provider> T getProvider(Class<T> provider, Object scope) {
        ArgumentChecker.throwIfNull(provider);
        T ret = this.getProviderFromAttribute(provider, scope);
        if (ret != null) {
            return ret;
        }
        return (T)((Provider)this.getProviderByCreateInstance(provider, scope));
    }

    private <T extends Provider> T getProviderFromAttribute(Class<T> provider, Object scope) {
        Object concreteProvider = this.getAttribute(provider.getName(), scope);
        if (concreteProvider == null) {
            return null;
        }
        if (!provider.isAssignableFrom(concreteProvider.getClass())) {
            throw new IllegalStateException("Bad attribute for " + provider + ". " + concreteProvider + " is not an instance of " + Provider.class);
        }
        return (T)((Provider)concreteProvider);
    }

    private <T> T getProviderByCreateInstance(Class<T> provider, Object scope) {
        Class<T>[] providers = this.strategyRegistrar_.getConcreteStrategies(provider);
        if (providers.length == 0) {
            throw new IllegalStateException("There are any concrete providers for " + provider);
        }
        try {
            T ret = providers[0].newInstance();
            this.setAttribute(provider.getName(), ret, scope);
            return ret;
        }
        catch (ClassCastException e) {
            throw new IllegalStateException("Bad attribute for " + provider + ". " + providers[0] + " is not an instance of " + Provider.class);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("Provider " + providers[0] + " has no default constructer.");
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Default constructer for provider " + providers[0] + " is not public scope.");
        }
    }

    @Override
    public void setAttribute(String key, Object attribute, Object scope) {
        Collection collection;
        ArgumentChecker.throwIfNull((Object)key, attribute);
        scope = this.toRootScopeIfNull(scope);
        if (scope instanceof Collection) {
            this.scopeMap_.put(scope, this.rootScope_);
        } else if (scope instanceof RootGameTree && (collection = this.findCollection((RootGameTree)scope)) != null) {
            this.scopeMap_.put(collection, scope);
        }
        Map<String, Object> map = this.attributeMap_.get(scope);
        if (map == null) {
            map = new HashMap<String, Object>();
            this.attributeMap_.put(scope, map);
        }
        map.put(key, attribute);
    }

    @Override
    public void setAttribute(ContextValue attribute, Object scope) {
        ArgumentChecker.throwIfNull((Object)attribute);
        this.setAttribute(attribute.id(), attribute.defaultValue(), scope);
    }

    private Object toRootScopeIfNull(Object scope) {
        return scope == null ? this.rootScope_ : scope;
    }

    private Collection findCollection(RootGameTree tree) {
        for (Object value : this.scopeMap_.keySet()) {
            if (!(value instanceof Collection)) continue;
            Collection collection = (Collection)value;
            int i = 0;
            while (i < collection.size()) {
                if (tree == collection.get(i)) {
                    return collection;
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    public String[] rootKeys() {
        Map<String, Object> map = this.attributeMap_.get(this.rootScope_);
        return map.keySet().toArray(new String[map.size()]);
    }

    @Override
    public Object getAttribute(String key, Object scope) {
        Object ret;
        Map map;
        ArgumentChecker.throwIfNull((Object)key);
        scope = this.toRootScopeIfNull(scope);
        Map<String, Object> rootMap = this.attributeMap_.get(this.rootScope_);
        do {
            if ((ret = (map = this.findMap(scope)).get(key)) != null) {
                return ret;
            }
            scope = this.scopeMap_.get(scope);
            scope = this.toRootScopeIfNull(scope);
        } while (map != rootMap);
        return ret;
    }

    private Map findMap(Object scope) {
        Map<String, Object> map = this.attributeMap_.get(scope);
        while (map == null) {
            scope = this.scopeMap_.get(scope);
            scope = this.toRootScopeIfNull(scope);
            map = this.attributeMap_.get(scope);
        }
        return map;
    }

    @Override
    public CurrentContext getCurrent(Object scope) {
        CurrentContext ret = this.contextMap_.get(scope = this.toRootScopeIfNull(scope));
        if (ret == null) {
            ret = new CurrentContextImpl(scope);
            this.contextMap_.put(scope, ret);
        }
        return ret;
    }

    @Override
    public Object[] clearCurrent(Object scope) {
        scope = this.toRootScopeIfNull(scope);
        this.scopeMap_.remove(scope);
        Map<String, Object> map = this.attributeMap_.remove(scope);
        this.contextMap_.remove(scope);
        if (map == null) {
            return new Object[0];
        }
        return map.keySet().toArray();
    }

    @Override
    public void addListener(ContextListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners_.add(listener);
    }

    @Override
    public void removeListener(ContextListener listener) {
        this.listeners_.remove(listener);
    }

    @Override
    public void fireAttributeChanged(String[] keys) {
        ArgumentChecker.throwIfNull((Object)keys);
        HashSet set = new HashSet(Arrays.asList(keys));
        Set<String> keySet = Collections.unmodifiableSet(set);
        ContextListener[] listeners = this.listeners_.toArray((ContextListener[])new ContextListener[0]);
        int i = 0;
        while (i < listeners.length) {
            listeners[i].attributeChanged(keySet);
            ++i;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NullCurrentContext
    implements CurrentContext {
        NullCurrentContext() {
        }

        @Override
        public <T extends Provider> T getProvider(Class<T> providerInterface) {
            return null;
        }

        @Override
        public <T extends Provider> void setProvider(Class<T> providerInterface, Provider provider) {
        }

        @Override
        public boolean getBoolean(String key) {
            return false;
        }

        @Override
        public boolean getBoolean(BooleanContextValue value) {
            return false;
        }

        @Override
        public int getInteger(IntContextValue resource) {
            return 0;
        }

        @Override
        public int getInteger(String key, int defaultValue) {
            return 0;
        }

        @Override
        public void setInteger(String key, int value) {
        }

        @Override
        public int[] getIntArray(String key, int[] defaultValue) {
            return defaultValue;
        }

        @Override
        public void setIntArray(String key, int[] value) {
        }

        @Override
        public int[] getIntArray(IntArrayContextValue size) {
            ArgumentChecker.throwIfNull((Object)size);
            return size.defaultIntArray();
        }

        @Override
        public File getFile(FileContextValue value) {
            ArgumentChecker.throwIfNull((Object)value);
            return value.defaultFile();
        }

        @Override
        public void setFile(String key, File file) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CurrentContextImpl
    implements CurrentContext {
        private final WeakReference<Object> reference_;

        CurrentContextImpl(Object scope) {
            this.reference_ = new WeakReference<Object>(scope);
        }

        @Override
        public <T extends Provider> T getProvider(Class<T> providerInterface) {
            return DefaultContext.this.getProvider(providerInterface, this.reference_.get());
        }

        @Override
        public <T extends Provider> void setProvider(Class<T> providerInterface, Provider provider) {
            DefaultContext.this.setAttribute(providerInterface.getName(), provider, this.reference_.get());
        }

        @Override
        public boolean getBoolean(String key) {
            Object value = DefaultContext.this.getAttribute(key, this.reference_.get());
            if (value == null || !(value instanceof Boolean)) {
                this.throwIllegalStateException(key, value);
            }
            return (Boolean)value;
        }

        @Override
        public boolean getBoolean(BooleanContextValue value) {
            ArgumentChecker.throwIfNull((Object)value);
            Object attr = DefaultContext.this.getAttribute(value.id(), this.reference_.get());
            if (attr == null || !(attr instanceof Boolean)) {
                return value.defaultBoolean();
            }
            return (Boolean)attr;
        }

        @Override
        public int getInteger(IntContextValue resource) {
            ArgumentChecker.throwIfNull((Object)resource);
            Object value = DefaultContext.this.getAttribute(resource.id(), this.reference_.get());
            if (value == null || !(value instanceof Integer)) {
                return resource.defaultInt();
            }
            return (Integer)value;
        }

        @Override
        public int getInteger(String key, int defaultValue) {
            Object value = DefaultContext.this.getAttribute(key, this.reference_.get());
            if (value == null) {
                return defaultValue;
            }
            if (!(value instanceof Integer)) {
                this.throwIllegalStateException(key, value);
            }
            return (Integer)value;
        }

        @Override
        public void setInteger(String key, int value) {
            DefaultContext.this.setAttribute(key, new Integer(value), this.reference_.get());
        }

        @Override
        public int[] getIntArray(String key, int[] defaultValue) {
            Object value = DefaultContext.this.getAttribute(key, this.reference_.get());
            if (value == null) {
                return defaultValue;
            }
            if (!(value instanceof int[])) {
                this.throwIllegalStateException(key, value);
            }
            return (int[])value;
        }

        @Override
        public int[] getIntArray(IntArrayContextValue value) {
            ArgumentChecker.throwIfNull((Object)value);
            return this.getIntArray(value.id(), value.defaultIntArray());
        }

        @Override
        public void setIntArray(String key, int[] value) {
            ArgumentChecker.throwIfNull((Object)value);
            DefaultContext.this.setAttribute(key, value, this.reference_.get());
        }

        @Override
        public File getFile(FileContextValue value) {
            ArgumentChecker.throwIfNull((Object)value);
            Object obj = DefaultContext.this.getAttribute(value.id(), this.reference_.get());
            if (obj == null) {
                return value.defaultFile();
            }
            if (!(obj instanceof File)) {
                this.throwIllegalStateException(value.id(), value);
            }
            return (File)obj;
        }

        @Override
        public void setFile(String key, File file) {
            ArgumentChecker.throwIfNull((Object)file);
            DefaultContext.this.setAttribute(key, file, this.reference_.get());
        }

        private void throwIllegalStateException(String key, Object value) {
            throw new IllegalStateException("Bad value. key='" + key + "', value='" + value + "'");
        }
    }
}

