/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import javax.swing.JOptionPane;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.lang.Runtimes;
import org.unitarou.lang.Strings;
import org.unitarou.ml.MessageResource;
import org.unitarou.ml.Messages;
import org.unitarou.sgf.util.provider.crdlp.CoordinatesLabelProvider;
import org.unitarou.yukinoshita.Application;
import org.unitarou.yukinoshita.context.Context;
import org.unitarou.yukinoshita.view.provider.blklp.BlockLabelProvider;
import org.unitarou.yukinoshita.view.provider.rgtlp.RootGameTreeLabelProvider;
import org.unitarou.yukinoshita.view.provider.vlp.NoVariationProvider;
import org.unitarou.yukinoshita.view.provider.vlp.VariationLabelProvider;

public class Yukinoshita {
    private static final String PROPERTIES_FILE_NAME = "." + File.separator + "yukinoshita.properties";
    private static final Log log_s_ = LogFactory.getLog(Yukinoshita.class);
    private static final MessageResource NT_FILE_READ_ERROR = new MessageResource(Yukinoshita.class, "ntFileReadError");
    private static final MessageResource MSG_PROPERTIES_FILE_NOT_FOUND = new MessageResource(Yukinoshita.class, "msgPropertiesFileNotFound");
    private static final MessageResource MSG_PROPERTIES_READ_ERROR = new MessageResource(Yukinoshita.class, "msgPropertiesReadError");
    private static final MessageResource NT_BAD_PARAMETER_IN_PROPERTIES = new MessageResource(Yukinoshita.class, "ntBadParameterInProperties");
    private static final MessageResource MSG_BAD_APPLICATION_CLASS_NAME = new MessageResource(Yukinoshita.class, "msgBadApplicationClassName");
    private static final MessageResource MSG_BAD_DEFAULT_CHARSET = new MessageResource(Yukinoshita.class, "msgBadDefaultCharset");
    private static final MessageResource MSG_BAD_PROVIDER_CLASS_NAME = new MessageResource(Yukinoshita.class, "msgBadProviderClassName");
    private static final MessageResource MSG_BAD_ARGUMENT_FILE_NOT_FOUND = new MessageResource(Yukinoshita.class, "msgBadArgumentFileNotFound");
    private static final String PROP_KEY_APPLICATION = "application";
    private static final String PROP_DEF_APPLICATION = "org.unitarou.yukinoshita.view.jface.JFaceApplication";
    private static final String PROP_KEY_DEFAULT_CHARSET = "defaultCharset";
    private static final String PROP_KEY_PREFIX_PROVIDER = "provider.";
    private static final MessageResource NT_MEMORY_IS_EXHAUSTED = new MessageResource(Yukinoshita.class, "ntMemoryIsExhausted");
    private static final MessageResource MSG_MEMORY_IS_EXHAUSTED = new MessageResource(Yukinoshita.class, "msgMemoryIsExhausted");
    private static final long FREEMEMORY_4_OPEN_FILE = 0x400000L;
    public static final String USER_NAME = System.getProperty("user.name", "yukinoshita");
    private static Yukinoshita yukinoshita_s_;
    private final Properties properties_ = this.readProperties();
    private Application application_ = this.loadApplication();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    public static void main(String[] args) {
        try {
            try {
                yukinoshita_s_ = new Yukinoshita();
                File[] files = Yukinoshita.paresFile(args);
                yukinoshita_s_.start(files);
                Messages.inspectUnusedMessages();
            }
            catch (Throwable e) {
                log_s_.fatal("Uncaught exception error.", e);
            }
        }
        finally {
            if (yukinoshita_s_ != null) {
                yukinoshita_s_.dispose();
            }
        }
    }

    private static File[] paresFile(String[] args) {
        ArrayList<File> files = new ArrayList<File>(args.length);
        String[] stringArray = args;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String pathName = stringArray[n];
            File file = new File(pathName);
            if (file.exists() && file.isFile()) {
                files.add(file);
            } else {
                log_s_.info(MSG_BAD_ARGUMENT_FILE_NOT_FOUND.get((Object)pathName));
            }
            ++n;
        }
        return files.toArray(new File[files.size()]);
    }

    public static Yukinoshita instance() {
        return yukinoshita_s_;
    }

    public static Application application() {
        return Yukinoshita.yukinoshita_s_.application_;
    }

    public static Context context() {
        return Yukinoshita.yukinoshita_s_.application_.getContext();
    }

    private Yukinoshita() {
    }

    private Properties readProperties() {
        Properties properties = new Properties();
        FileInputStream fileInputStream = null;
        try {
            try {
                fileInputStream = new FileInputStream(PROPERTIES_FILE_NAME);
                properties.load(fileInputStream);
            }
            catch (FileNotFoundException e) {
                log_s_.warn("Properties file is not found.", e);
                JOptionPane.showMessageDialog(null, MSG_PROPERTIES_FILE_NOT_FOUND.get((Object)PROPERTIES_FILE_NAME), NT_FILE_READ_ERROR.get(), 2);
            }
            catch (IOException e) {
                log_s_.warn("Failure to read properties file.", e);
                JOptionPane.showMessageDialog(null, MSG_PROPERTIES_READ_ERROR.get((Object)PROPERTIES_FILE_NAME), NT_FILE_READ_ERROR.get(), 2);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fileInputStream);
            throw throwable;
        }
        IOUtils.closeQuietly(fileInputStream);
        return properties;
    }

    private Application loadApplication() {
        String appClassName = this.properties_.getProperty(PROP_KEY_APPLICATION, PROP_DEF_APPLICATION);
        try {
            Class<?> clazz = Class.forName(appClassName);
            return (Application)clazz.newInstance();
        }
        catch (Exception e) {
            log_s_.warn("Failure to create an application instance.", e);
            JOptionPane.showMessageDialog(null, MSG_BAD_APPLICATION_CLASS_NAME.get(PROP_KEY_APPLICATION, appClassName, PROP_DEF_APPLICATION), NT_BAD_PARAMETER_IN_PROPERTIES.get(), 2);
            try {
                return (Application)Class.forName(PROP_DEF_APPLICATION).newInstance();
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
        }
    }

    private void start(File[] files) {
        this.setupProvider();
        this.setupCharset();
        this.setupContextProperties();
        this.application_.getContext().loadContext();
        this.application_.start(files);
    }

    private void setupProvider() {
        Context context = this.application_.getContext();
        context.registerInterface(CoordinatesLabelProvider.class);
        context.registerInterface(VariationLabelProvider.class);
        context.registerInterface(BlockLabelProvider.class);
        context.registerInterface(RootGameTreeLabelProvider.class);
        context.registerProvider(CoordinatesLabelProvider.CONTEXT.defaultProvider().getClass());
        context.registerProvider(VariationLabelProvider.CONTEXT.defaultProvider().getClass());
        context.registerProvider(BlockLabelProvider.CONTEXT.defaultProvider().getClass());
        context.registerProvider(RootGameTreeLabelProvider.CONTEXT.defaultProvider().getClass());
        context.registerProvider(NoVariationProvider.class);
        for (Map.Entry<Object, Object> entry : this.properties_.entrySet()) {
            String key = entry.getKey().toString();
            String value = entry.getValue().toString();
            try {
                if (!key.startsWith(PROP_KEY_PREFIX_PROVIDER)) continue;
                context.registerProvider(Class.forName(value));
            }
            catch (ClassNotFoundException e) {
                log_s_.warn("Failure to set provider class.", e);
                this.application_.openMessageDialog(Application.MessageLevel.WARNING, NT_BAD_PARAMETER_IN_PROPERTIES.get(), MSG_BAD_PROVIDER_CLASS_NAME.get(key, value));
            }
        }
    }

    private void setupCharset() {
        Context context = this.application_.getContext();
        Collection<Charset> charsets = Charset.availableCharsets().values();
        context.setAttribute(Context.KEY_CHARSETS, charsets.toArray(new Charset[charsets.size()]), null);
        Charset charset = Charset.forName("UTF-8");
        String charsetName = this.properties_.getProperty(PROP_KEY_DEFAULT_CHARSET);
        try {
            charset = Charset.forName(charsetName);
        }
        catch (Exception e) {
            log_s_.warn("Failure to get default charset.", e);
            this.application_.openMessageDialog(Application.MessageLevel.WARNING, NT_BAD_PARAMETER_IN_PROPERTIES.get(), MSG_BAD_DEFAULT_CHARSET.get(PROP_KEY_DEFAULT_CHARSET, Strings.nullToNullMark(charsetName), charset.name()));
        }
        context.setAttribute(Context.KEY_DEFAULT_CHARSET, charset, null);
    }

    private void setupContextProperties() {
        Context context = this.application_.getContext();
        context.setAttribute(Context.FILE_DIALOG_STYLE, null);
        context.setAttribute(Context.SHOW_LAST_MOVE_MARK, null);
        context.setAttribute(Context.DEFAULT_EDIT_MODE, null);
        context.setAttribute(Context.MAX_STONE_SIZE, null);
    }

    private void dispose() {
        this.application_.dispose();
    }

    public String getName() {
        return "Yukinoshita";
    }

    public String getVersion() {
        return "2 beta 7";
    }

    public String getLastUpdate() {
        return "2005/12/03";
    }

    public boolean checkFreeMemory() {
        int GC_UPPER_LIMIT = 6;
        int counter = 0;
        while (Runtimes.availableMemory() < 0x400000L && counter < 6) {
            System.gc();
            ++counter;
        }
        if (counter == 6) {
            this.application_.openMessageDialog(Application.MessageLevel.WARNING, NT_MEMORY_IS_EXHAUSTED.get(), MSG_MEMORY_IS_EXHAUSTED.get());
            return false;
        }
        return true;
    }
}

