/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.unitarou.ml.Messages;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.io.CollectionRepository;
import org.unitarou.sgf.parser.SgfFormatter;
import org.unitarou.sgf.type.GameType;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.YukinoshitaException;

public final class FileManager {
    private static final Messages msg_s_ = Messages.createByPackage(FileManager.class);
    private static final String MSG_FILE_IO_ERROR = Messages.createKey(FileManager.class, "msgFileIoError");
    private static final String MSG_FILE_OPEN_ERROR = Messages.createKey(FileManager.class, "msgFileOpenError");
    private static final String MSG_ERROR_ON_WRITE = Messages.createKey(FileManager.class, "msgErrorOnWrite");
    private static final File trashCan_s_ = new File("./trushCan.sgf");
    private static final FileManager instance_s_ = new FileManager();
    private final Map<File, Collection> fileMap_ = new HashMap<File, Collection>();
    static /* synthetic */ Class class$0;

    public static FileManager instance() {
        return instance_s_;
    }

    private FileManager() {
    }

    public Collection open(File file) {
        ArgumentChecker.throwIfNull((Object)file);
        Collection collection = this.fileMap_.get(file);
        if (collection != null) {
            return collection;
        }
        collection = CollectionRepository.instance().retrieve(file);
        this.fileMap_.put(file, collection);
        return collection;
    }

    public void close(Collection collection) {
        ArgumentChecker.throwIfNull((Object)collection);
        if (collection.getFile() != null) {
            this.fileMap_.remove(collection.getFile());
        }
    }

    public void save(Collection collection) throws YukinoshitaException {
        ArgumentChecker.throwIfNull((Object)collection);
        if (collection.getFile() == null) {
            throw new IllegalArgumentException("collection.getFile() must not be null.");
        }
        if (GameType.DRILL.equals(collection.get(0).getGameType())) {
            collection = new Collection(collection);
            while (1 < collection.size()) {
                collection.remove(collection.get(1));
            }
        }
        SgfFormatter sgfFormater = new SgfFormatter();
        FileOutputStream fileOutputStream = null;
        try {
            try {
                ByteBuffer byteBuffer = sgfFormater.format(collection);
                fileOutputStream = new FileOutputStream(collection.getFile());
                fileOutputStream.getChannel().write(byteBuffer);
                fileOutputStream.flush();
            }
            catch (FileNotFoundException e) {
                throw new YukinoshitaException(msg_s_.get(MSG_FILE_OPEN_ERROR, e.getLocalizedMessage()), e);
            }
            catch (IOException e) {
                throw new YukinoshitaException(msg_s_.get(MSG_FILE_IO_ERROR, e.getLocalizedMessage()), e);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fileOutputStream);
            throw throwable;
        }
        IOUtils.closeQuietly(fileOutputStream);
    }

    public void drop(RootGameTree rgt) {
        Collection collection = null;
        try {
            try {
                collection = this.openTrashCan();
                collection.addLast(rgt);
                this.save(collection);
            }
            catch (YukinoshitaException e) {
                e.printStackTrace();
            }
        }
        finally {
            if (collection != null) {
                this.close(collection);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RootGameTree pickUp(int index) {
        RootGameTree ret = null;
        Collection trashCan = null;
        try {
            trashCan = this.openTrashCan();
            if (index < 0) throw new IllegalArgumentException("Bad index (out of range):" + index);
            if (trashCan.size() <= index) {
                throw new IllegalArgumentException("Bad index (out of range):" + index);
            }
            ret = trashCan.get(index);
            trashCan.remove(ret);
            this.save(trashCan);
            RootGameTree rootGameTree = ret;
            return rootGameTree;
        }
        catch (YukinoshitaException e) {
            e.printStackTrace();
            RootGameTree rootGameTree = ret;
            if (trashCan == null) return rootGameTree;
            this.close(trashCan);
            return rootGameTree;
        }
        finally {
            if (trashCan != null) {
                this.close(trashCan);
            }
        }
    }

    public Collection getTrashCan() {
        Collection trashCan = null;
        try {
            trashCan = this.openTrashCan();
            Collection collection = new Collection(trashCan);
            return collection;
        }
        finally {
            if (trashCan != null) {
                this.close(trashCan);
            }
        }
    }

    public void clearTrashCan() {
        trashCan_s_.delete();
    }

    private Collection openTrashCan() {
        if (!trashCan_s_.exists()) {
            Collection collection = new Collection();
            collection.setFile(trashCan_s_);
            return collection;
        }
        return this.open(trashCan_s_);
    }
}

