/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.unitarou.util.ArgumentChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeakedList<T>
implements Iterable<T> {
    private final ReferenceQueue<T> referenceQueue_ = new ReferenceQueue();
    private final LinkedList<Reference<T>> linkedList_ = new LinkedList();

    public boolean add(T o) {
        ArgumentChecker.throwIfNull(o);
        return this.linkedList_.add(new WeakReference<T>(o, this.referenceQueue_));
    }

    public void addAll(WeakedList<T> os) {
        ArgumentChecker.throwIfNull(os);
        for (T o : os) {
            this.linkedList_.add(new WeakReference<T>(o, this.referenceQueue_));
        }
    }

    public boolean remove(T o) {
        boolean finds = false;
        Iterator ip = this.linkedList_.iterator();
        while (ip.hasNext()) {
            Object obj = ((Reference)ip.next()).get();
            if (obj == null) {
                ip.remove();
                continue;
            }
            if (!obj.equals(o)) continue;
            ip.remove();
            finds = true;
        }
        return finds;
    }

    public T[] toArray(T[] holder) {
        ArgumentChecker.throwIfNull(holder);
        List<T> liveInstances = this.getLiveInstances();
        return liveInstances.toArray(holder);
    }

    private List<T> getLiveInstances() {
        ArrayList instances = new ArrayList(this.linkedList_.size());
        Iterator ip = this.linkedList_.iterator();
        while (ip.hasNext()) {
            Object obj = ((Reference)ip.next()).get();
            if (obj == null) {
                ip.remove();
                continue;
            }
            instances.add(obj);
        }
        return instances;
    }

    @Override
    public Iterator<T> iterator() {
        return new IteratorImpl();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IteratorImpl
    implements Iterator<T> {
        private final List<T> array_;
        private int index_;

        IteratorImpl() {
            this.array_ = WeakedList.this.getLiveInstances();
            this.index_ = 0;
        }

        @Override
        public boolean hasNext() {
            return this.index_ < this.array_.size();
        }

        @Override
        public T next() {
            if (this.hasNext()) {
                return this.array_.get(this.index_++);
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

