/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.unitarou.util.ArgumentChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StrategyRegistrar {
    private final Map<Class<?>, List<Class<?>>> registerMap_ = new HashMap();

    public boolean registerStrategy(Class<?> abstractStragety) {
        ArgumentChecker.throwIfNull(abstractStragety);
        List<Class<?>> list = this.registerMap_.get(abstractStragety);
        if (list == null) {
            list = new ArrayList();
            this.registerMap_.put(abstractStragety, list);
            return true;
        }
        return false;
    }

    public Class<?>[] registerConcreteStrategy(Class<?> concreteStrategy) {
        ArgumentChecker.throwIfNull(concreteStrategy);
        ArrayList registered = new ArrayList();
        for (Map.Entry<Class<?>, List<Class<?>>> entry : this.registerMap_.entrySet()) {
            Class<?> abstractStrategy = entry.getKey();
            if (!abstractStrategy.isAssignableFrom(concreteStrategy)) continue;
            List<Class<?>> list = entry.getValue();
            list.add(concreteStrategy);
            registered.add(abstractStrategy);
        }
        return registered.toArray(new Class[registered.size()]);
    }

    public void clear() {
        this.registerMap_.clear();
    }

    public Class<?>[] getStrategies() {
        return this.registerMap_.keySet().toArray(new Class[this.registerMap_.size()]);
    }

    public <T> Class<T>[] getConcreteStrategies(Class<T> abstractStrategy) {
        ArgumentChecker.throwIfNull(abstractStrategy);
        Class[] ret = (Class[])Array.newInstance(abstractStrategy.getClass(), 0);
        List<Class<?>> list = this.registerMap_.get(abstractStrategy);
        if (list == null) {
            return ret;
        }
        ArrayList classes = new ArrayList(list.size());
        for (Class<?> clazz : list) {
            classes.add(clazz);
        }
        return classes.toArray(ret);
    }

    public <T> T[] getConcreteStrategyInstances(Class<T> abstractStrategy) {
        ArgumentChecker.throwIfNull(abstractStrategy);
        Object[] ret = (Object[])Array.newInstance(abstractStrategy, 0);
        List<Class<?>> list = this.registerMap_.get(abstractStrategy);
        if (list == null) {
            return ret;
        }
        ArrayList instances = new ArrayList(list.size());
        for (Class<?> clazz : list) {
            try {
                instances.add(clazz.newInstance());
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return instances.toArray(ret);
    }
}

