/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.swt;

import java.text.StringCharacterIterator;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.unitarou.lang.Strings;
import org.unitarou.util.ArgumentChecker;

public class Swts {
    public static void disposeQuietly(Resource resource) {
        if (resource != null && !resource.isDisposed()) {
            resource.dispose();
        }
    }

    public static Point topLeft(Rectangle rectangle) {
        ArgumentChecker.throwIfNull((Object)rectangle);
        return Geometry.getLocation(rectangle);
    }

    public static Point bottomRight(Rectangle rectangle) {
        ArgumentChecker.throwIfNull((Object)rectangle);
        return new Point(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
    }

    public static String toWidgetText(String charSequence) {
        ArgumentChecker.throwIfNull((Object)charSequence);
        StringBuilder builder = new StringBuilder(charSequence.length());
        StringCharacterIterator ip = new StringCharacterIterator(charSequence);
        char c = ip.first();
        while (c != '\uffff') {
            if (!Character.isISOControl(c) || Character.isWhitespace(c)) {
                if (c == '\r') {
                    if (ip.next() != '\n') {
                        ip.previous();
                    }
                    builder.append(Strings.LINE_SEPARATOR);
                } else if (c == '\n') {
                    builder.append(Strings.LINE_SEPARATOR);
                } else {
                    builder.append(c);
                }
            }
            c = ip.next();
        }
        return builder.toString();
    }

    public static Point add(Point p1, Point p2, int type) {
        Point ret = new Point(0, 0);
        ret.x = (type & 0x100) != 0 ? p1.x + p2.x : Math.max(p1.x, p2.x);
        ret.y = (type & 0x200) != 0 ? p1.y + p2.y : Math.max(p1.y, p2.y);
        return ret;
    }

    protected Swts() {
    }
}

