/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.util.provider.plp;

import java.util.HashSet;
import org.unitarou.ml.MessageResource;
import org.unitarou.ml.Messages;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.util.provider.crdlp.CoordinatesLabelProvider;
import org.unitarou.sgf.util.provider.plp.PropertyLabelProvider;
import org.unitarou.util.ArgumentChecker;

public class BasicPropertyLabelProvider
implements PropertyLabelProvider {
    private static final Messages messages_s_ = Messages.createByPackage(BasicPropertyLabelProvider.class);
    private static final MessageResource LB_NAME = new MessageResource(BasicPropertyLabelProvider.class, "lbName");
    private CoordinatesLabelProvider clProvider_ = CoordinatesLabelProvider.CONTEXT.defaultProvider();
    static /* synthetic */ Class class$0;

    public String displayName() {
        return LB_NAME.get();
    }

    public void setCoordinatesLabelProvider(CoordinatesLabelProvider provider) {
        ArgumentChecker.throwIfNull((Object)provider);
        this.clProvider_ = provider;
    }

    public CoordinatesLabelProvider getCoordinatesLabelProvider() {
        return this.clProvider_;
    }

    public String getLabel(GameType gameType, Property property) {
        ArgumentChecker.throwIfNull((Object)gameType, (Object)property);
        switch (property.sgfId().valueType()) {
            case DOUBLE: 
            case COLOR: {
                return this.getLabelWithValue(gameType, property);
            }
        }
        return this.getLabelWithIdOnly(gameType, property);
    }

    private String getLabelWithValue(GameType gameType, Property property) {
        String keyPrefix = Messages.createKey(BasicPropertyLabelProvider.class, String.valueOf(gameType.getString()) + '.' + property.sgfId().id() + '.');
        HashSet<String> labels = new HashSet<String>();
        String[] stringArray = property.value().getStrings();
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String string = stringArray[n];
            String key = String.valueOf(keyPrefix) + string;
            if (messages_s_.contains(key)) {
                labels.add(messages_s_.get(key));
            } else {
                labels.add(property.sgfId().displayName());
            }
            ++n;
        }
        StringBuilder builder = new StringBuilder();
        for (String label : labels) {
            builder.append(label).append(", ");
        }
        if (!labels.isEmpty()) {
            builder.delete(builder.length() - 2, builder.length());
        }
        return builder.toString();
    }

    private String getLabelWithIdOnly(GameType gameType, Property property) {
        String key = Messages.createKey(BasicPropertyLabelProvider.class, String.valueOf(gameType.getString()) + '.' + property.sgfId().id());
        if (messages_s_.contains(key)) {
            return messages_s_.get(key);
        }
        return property.sgfId().displayName();
    }
}

