/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.util.filter;

import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.util.SgfPointType;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.util.FilterException;
import org.unitarou.util.NestedFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionFilter
extends NestedFilter<SgfPoint> {
    public ReflectionFilter() {
        this((NestedFilter<SgfPoint>)null);
    }

    public ReflectionFilter(NestedFilter<SgfPoint> parent) {
        super(parent);
    }

    @Override
    public SgfPoint filter(SgfPoint sgfPoint) throws FilterException {
        ArgumentChecker.throwIfNull((Object)sgfPoint);
        sgfPoint = super.filter(sgfPoint);
        if (sgfPoint.condition().equals((Object)SgfPointType.PASS)) {
            return sgfPoint;
        }
        int x = sgfPoint.y();
        int y = sgfPoint.x();
        SgfSize size = sgfPoint.size();
        if (x <= size.width() && y <= size.height()) {
            return SgfPoint.create(sgfPoint.size(), x, y);
        }
        throw new FilterException();
    }
}

