/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.util;

import org.unitarou.lang.Objects;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.util.ArgumentChecker;

public class Stone {
    public static final Stone NULL_STONE = new Stone();
    public static final Stone[] EMPTY_ARRAY = new Stone[0];
    private final SgfColor color_;
    private final SgfPoint point_;
    private final Integer number_;
    private final Double timeLapsed_;

    public static Stone create(Node node, SgfSize sgfSize) {
        ArgumentChecker.throwIfNull((Object)node, (Object)sgfSize);
        SgfColor[] sgfColorArray = new SgfColor[]{SgfColor.WHITE, SgfColor.BLACK};
        int n = 0;
        int n2 = sgfColorArray.length;
        while (n < n2) {
            SgfColor color = sgfColorArray[n];
            Property p = node.getProperty(color.moveType());
            if (p != null) {
                return new Stone(color, SgfPoint.parseMoveQuietly(sgfSize, p.value().getString()), null);
            }
            ++n;
        }
        return NULL_STONE;
    }

    private Stone() {
        this.color_ = null;
        this.point_ = null;
        this.number_ = null;
        this.timeLapsed_ = null;
    }

    public Stone(SgfColor color, SgfPoint point, Integer number) {
        this(color, point, number, null);
    }

    public Stone(SgfColor color, SgfPoint point, Integer number, Double timeLapsed) {
        ArgumentChecker.throwIfNull((Object)color, (Object)point);
        this.color_ = color;
        this.point_ = point;
        this.number_ = number;
        this.timeLapsed_ = timeLapsed;
    }

    public SgfPoint getPoint() {
        return this.point_;
    }

    public SgfColor getColor() {
        return this.color_;
    }

    public Integer getNumber() {
        return this.number_;
    }

    public Double getTimeLapsed() {
        return this.timeLapsed_;
    }

    public boolean isValid() {
        return this.point_ != null && this.color_ != null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        Stone s = (Stone)obj;
        return Objects.equalsIncludeNull(this.color_, s.color_) && Objects.equalsIncludeNull(this.point_, s.point_) && Objects.equalsIncludeNull(this.number_, s.number_);
    }

    public int hashCode() {
        return Objects.hashCodeIncludeNull(this.color_) + 3 * Objects.hashCodeIncludeNull(this.number_) + 1033 * Objects.hashCodeIncludeNull(this.point_);
    }
}

