/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.util;

import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.util.ArgumentChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SgfPointType {
    BLACK,
    WHITE,
    EMPTY,
    FORBIDDEN,
    OVERLAP,
    TOP_LEFT,
    TOP,
    TOP_RIGHT,
    LEFT,
    RIGHT,
    BOTTOM_LEFT,
    BOTTOM,
    BOTTOM_RIGHT,
    STAR,
    IN,
    OUT,
    PASS;


    public static SgfPointType classify(SgfPoint point) {
        ArgumentChecker.throwIfNull((Object)point);
        int x = point.x();
        int y = point.y();
        SgfSize size = point.size();
        if (x == 1) {
            return y == 1 ? TOP_LEFT : (y == size.height() ? BOTTOM_LEFT : LEFT);
        }
        if (x == size.width()) {
            return y == 1 ? TOP_RIGHT : (y == size.height() ? BOTTOM_RIGHT : RIGHT);
        }
        return y == 1 ? TOP : (y == size.height() ? BOTTOM : EMPTY);
    }
}

