/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.util.SgfPointType;
import org.unitarou.sgf.util.SgfRectangle;
import org.unitarou.util.ArgumentChecker;

public class SgfPointSet {
    private final Set<SgfPoint> pointSet_ = new HashSet<SgfPoint>();

    public void add(SgfPoint point) {
        ArgumentChecker.throwIfNull((Object)point);
        this.pointSet_.add(point);
    }

    public void add(SgfPoint[] points) {
        ArgumentChecker.throwIfNull(points);
        int i = 0;
        while (i < points.length) {
            this.pointSet_.add(points[i]);
            ++i;
        }
    }

    public void remove(SgfPoint point) {
        ArgumentChecker.throwIfNull((Object)point);
        this.pointSet_.remove(point);
    }

    public void remove(SgfPoint[] points) {
        ArgumentChecker.throwIfNull(points);
        int i = 0;
        while (i < points.length) {
            this.pointSet_.remove(points[i]);
            ++i;
        }
    }

    public boolean contains(SgfPoint point) {
        ArgumentChecker.throwIfNull((Object)point);
        return this.pointSet_.contains(point);
    }

    public boolean isEmpty() {
        return this.pointSet_.isEmpty();
    }

    public void clear() {
        this.pointSet_.clear();
    }

    public SgfRectangle calcRedrawArea() {
        SgfRectangle redrawArea = new SgfRectangle();
        Iterator<SgfPoint> ip = this.pointSet_.iterator();
        while (ip.hasNext()) {
            redrawArea.intersect(ip.next());
        }
        return redrawArea;
    }

    public SgfRectangle[] getRegularRectangles() {
        ArrayList<SgfRectangle> list = new ArrayList<SgfRectangle>();
        TreeSet<SgfPoint> workSet = new TreeSet<SgfPoint>(this.pointSet_);
        while (!workSet.isEmpty()) {
            SgfPoint element = (SgfPoint)workSet.iterator().next();
            if (element.condition().equals((Object)SgfPointType.PASS)) {
                workSet.remove(element);
                continue;
            }
            SgfRectangle rectangle = this.findBestRectangle(workSet, element);
            list.add(rectangle);
            int x = rectangle.getStart().x();
            while (x <= rectangle.getEnd().x()) {
                int y = rectangle.getStart().y();
                while (y <= rectangle.getEnd().y()) {
                    workSet.remove(SgfPoint.create(element.size(), x, y));
                    ++y;
                }
                ++x;
            }
        }
        return list.toArray(new SgfRectangle[list.size()]);
    }

    private SgfRectangle findBestRectangle(Set pointSet, SgfPoint start) {
        int endX = start.x();
        int x = start.x() + 1;
        while (x <= start.size().width()) {
            SgfPoint point = SgfPoint.create(start.size(), x, start.y());
            if (!pointSet.contains(point)) break;
            endX = x++;
        }
        int endY = start.y();
        int y = start.y() + 1;
        while (y <= start.size().height()) {
            SgfPoint point = SgfPoint.create(start.size(), start.x(), y);
            if (!pointSet.contains(point)) break;
            endY = y++;
        }
        int[] area = new int[endY - start.y() + 1];
        area[0] = endX - start.x() + 1;
        int y2 = start.y() + 1;
        while (y2 <= endY) {
            int lastX = start.x();
            int x2 = start.x() + 1;
            while (x2 <= endX) {
                SgfPoint point = SgfPoint.create(start.size(), x2, y2);
                if (!pointSet.contains(point)) {
                    endX = lastX;
                    break;
                }
                lastX = x2++;
            }
            area[y2 - start.y()] = (y2 - start.y() + 1) * (endX - start.x() + 1);
            ++y2;
        }
        int maxRow = 0;
        int maxArea = area[0];
        int i = 1;
        while (i < area.length) {
            if (maxArea < area[i]) {
                maxArea = area[i];
                maxRow = i;
            }
            ++i;
        }
        int maxCol = maxArea / ++maxRow;
        SgfRectangle ret = new SgfRectangle();
        ret.set(start, SgfPoint.create(start.size(), start.x() + maxCol - 1, start.y() + maxRow - 1));
        return ret;
    }
}

