/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.util;

import java.util.IdentityHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.util.ArgumentChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SgfArgumentChecker {
    private static final Log logInspect_s_ = LogFactory.getLog(String.valueOf(SgfArgumentChecker.class.getName()) + ".INSPECT");
    static /* synthetic */ Class class$0;

    public static void throwIfNotAChild(Node node, GameTree parent) {
        if (!logInspect_s_.isDebugEnabled()) {
            return;
        }
        ArgumentChecker.throwIfNull((Object)node, (Object)parent);
        for (Node n : parent.getSequence()) {
            if (n != node) continue;
            return;
        }
        throw new IllegalArgumentException(node + " is not a child of " + parent);
    }

    public static void throwIfInvalid(RootGameTree rootGameTree) {
        if (!logInspect_s_.isDebugEnabled()) {
            return;
        }
        ArgumentChecker.throwIfNull((Object)rootGameTree);
        IdentityHashMap<GameTree, Object> gameTreeMap = new IdentityHashMap<GameTree, Object>();
        IdentityHashMap<Node, Object> nodeMap = new IdentityHashMap<Node, Object>();
        SgfArgumentChecker.throwIfInvalidImpl(gameTreeMap, nodeMap, rootGameTree);
        logInspect_s_.debug("No problems occurred,");
    }

    private static void throwIfInvalidImpl(IdentityHashMap<GameTree, Object> gameTreeMap, IdentityHashMap<Node, Object> nodeMap, GameTree gameTree) {
        if (gameTreeMap.containsKey(gameTree)) {
            throw new IllegalArgumentException(gameTree + " show twice");
        }
        gameTreeMap.put(gameTree, new Object());
        for (Node node : gameTree.getSequence()) {
            if (nodeMap.containsKey(node)) {
                throw new IllegalArgumentException(node + " show twice");
            }
            nodeMap.put(node, new Object());
        }
        GameTree[] gameTreeArray = gameTree.getChildren();
        int n = 0;
        int n2 = gameTreeArray.length;
        while (n < n2) {
            GameTree child = gameTreeArray[n];
            if (child instanceof RootGameTree) {
                throw new IllegalArgumentException(child + " has RootGameTree.");
            }
            if (child.getParent() != gameTree) {
                throw new IllegalArgumentException(child + " doesn't indicate Parent.");
            }
            SgfArgumentChecker.throwIfInvalidImpl(gameTreeMap, nodeMap, child);
            ++n;
        }
    }
}

