/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.type;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.TypeParseException;
import org.unitarou.sgf.type.TypedString;
import org.unitarou.util.ArgumentChecker;

public class TimeLapsed
implements TypedString {
    private static final Log log_s_ = LogFactory.getLog(TimeLapsed.class);
    private static final Pattern condition_s_ = Pattern.compile("(\\d+)\\s*,\\s*(\\d+)");
    private static final int TIME_LAPSED_POS = 1;
    private static final int TIME_DELAY_POS = 2;
    private final int timeLapsed_;
    private final int timeDelay_;
    static /* synthetic */ Class class$0;

    public static TimeLapsed parse(String value) throws TypeParseException {
        ArgumentChecker.throwIfNull((Object)value);
        Matcher matched = condition_s_.matcher(value);
        if (!matched.matches()) {
            throw new TypeParseException("Bad argument value = " + value);
        }
        return new TimeLapsed(Integer.parseInt(matched.group(1)), Integer.parseInt(matched.group(2)));
    }

    public static TimeLapsed parseQuietly(String value) {
        try {
            return TimeLapsed.parse(value);
        }
        catch (TypeParseException e) {
            log_s_.debug("Parse failure: ", e);
            return null;
        }
    }

    public TimeLapsed(int timeLapsed, int timeDelay) {
        this.timeLapsed_ = timeLapsed;
        this.timeDelay_ = timeDelay;
    }

    public int getTimeLapsed() {
        return this.timeLapsed_;
    }

    public int getTimeDelay() {
        return this.timeDelay_;
    }

    public boolean acceptable(SgfId sgfId) {
        ArgumentChecker.throwIfNull((Object)sgfId);
        return sgfId.equals(SgfId.TIME_LAPSED);
    }

    public String getString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.timeLapsed_).append(',').append(this.timeDelay_);
        return stringBuilder.toString();
    }

    public int compareTo(Object o) {
        TimeLapsed tl = (TimeLapsed)o;
        int ret = this.timeLapsed_ - tl.timeLapsed_;
        if (ret != 0) {
            return ret;
        }
        return this.timeDelay_ - tl.timeDelay_;
    }
}

