/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.type;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unitarou.lang.NullArgumentException;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.TypeParseException;
import org.unitarou.sgf.type.TypedString;
import org.unitarou.sgf.util.SgfPointType;
import org.unitarou.util.ArgumentChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SgfSize
implements TypedString {
    public static final int MAX_LENGTH = 52;
    public static final int OLD_PASS_POS = 20;
    private static final Pattern condition_s_ = Pattern.compile("(\\d{1,2})((\\s*:\\s*)(\\d{1,2}))?");
    private static final int WIDTH_POS = 1;
    private static final int HEIGHT_POS = 4;
    private static final int DEFAULT_WIDTH = 19;
    private static final int DEFAULT_HEIGHT = 19;
    private static final SortedMap<Integer, SgfSize> cache_s_ = new TreeMap<Integer, SgfSize>();
    public static final SgfSize DEFAULT = SgfSize.create(19, 19);
    public static final SgfSize MAX = SgfSize.create(52, 52);
    private final int width_;
    private final int height_;
    private final Set<SgfPoint> all_;
    private Integer primaryKey_;
    private String toString_;

    public static SgfSize parse(String value) throws TypeParseException {
        if (value == null) {
            throw new NullArgumentException("vaule must not be null.");
        }
        Matcher matched = condition_s_.matcher(value);
        if (!matched.matches()) {
            throw new TypeParseException("Bad argument value = " + value);
        }
        int w = Integer.parseInt(matched.group(1));
        String height = matched.group(4);
        int h = height != null ? Integer.parseInt(height) : w;
        return SgfSize.create(w, h);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SgfSize create(int width, int height) {
        if (width < 1 || 52 < width || height < 1 || 52 < height) {
            throw new IllegalArgumentException();
        }
        Integer key = new Integer(width + height * 52);
        SortedMap<Integer, SgfSize> sortedMap = cache_s_;
        synchronized (sortedMap) {
            SgfSize ret = (SgfSize)cache_s_.get(key);
            if (ret == null) {
                ret = new SgfSize(width, height);
                cache_s_.put(key, ret);
            }
            return ret;
        }
    }

    private SgfSize(int width, int height) {
        assert (1 <= width && width <= 52 && 1 <= height && height <= 52);
        this.width_ = width;
        this.height_ = height;
        this.all_ = new HashSet<SgfPoint>(width * height);
        this.primaryKey_ = null;
        this.toString_ = null;
    }

    public int width() {
        return this.width_;
    }

    public int height() {
        return this.height_;
    }

    public Set<SgfPoint> all() {
        if (!this.all_.isEmpty()) {
            return Collections.unmodifiableSet(this.all_);
        }
        int x = 1;
        while (x <= this.width_) {
            int y = 1;
            while (y <= this.height_) {
                this.all_.add(SgfPoint.create(this, x, y));
                ++y;
            }
            ++x;
        }
        return Collections.unmodifiableSet(this.all_);
    }

    public SgfPointType check(int x, int y) {
        if (x > 0 && x <= this.width_ && y > 0 && y <= this.height_) {
            return SgfPointType.IN;
        }
        if (x == 0 && y == 0 || x == 20 && y == 20 && this.width_ < 20 && this.height_ < 20) {
            return SgfPointType.PASS;
        }
        return SgfPointType.OUT;
    }

    @Override
    public boolean acceptable(SgfId sgfId) {
        ArgumentChecker.throwIfNull((Object)sgfId);
        return sgfId.equals(SgfId.SIZE);
    }

    @Override
    public String getString() {
        if (this.width_ == this.height_) {
            return String.valueOf(this.width_);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.width_);
        sb.append(':');
        sb.append(this.height_);
        return sb.toString();
    }

    @Override
    public int compareTo(Object o) {
        SgfSize obj = (SgfSize)o;
        return this.width_ + this.height_ * 52 - (obj.width_ + obj.height_ * 52);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof SgfSize)) {
            return false;
        }
        SgfSize size = (SgfSize)obj;
        return this.height_ == size.height_ && this.width_ == size.width_;
    }

    public int hashCode() {
        return this.primaryKey();
    }

    public int primaryKey() {
        if (this.primaryKey_ == null) {
            this.primaryKey_ = new Integer(this.height_ * 52 + this.width_);
        }
        return this.primaryKey_;
    }

    public String toString() {
        if (this.toString_ == null) {
            StringBuilder sb = new StringBuilder();
            sb.append('(');
            sb.append(this.width_);
            sb.append(',');
            sb.append(this.height_);
            sb.append(')');
            this.toString_ = sb.toString();
        }
        return this.toString_;
    }

    public boolean isStarPoint(SgfPoint point) {
        if (this.width_ % 2 + this.height_ % 2 == 2 && point.x() == this.width_ / 2 + 1 && point.y() == this.height_ / 2 + 1) {
            return true;
        }
        int X = point.x();
        int Y = point.y();
        if (X > this.width_ / 2) {
            X = this.width_ - X + 1;
        }
        if (Y > this.height_ / 2) {
            Y = this.height_ - Y + 1;
        }
        if (this.width_ >= 13 && this.height_ >= 13 && X == Y && X == 4) {
            return true;
        }
        if (this.width_ >= 19 && point.x() == this.width_ / 2 + 1 && Y == 4) {
            return true;
        }
        return this.height_ >= 19 && point.y() == this.height_ / 2 + 1 && X == 4;
    }
}

