/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.type;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.ValueType;
import org.unitarou.sgf.type.TypeParseException;
import org.unitarou.sgf.type.TypedString;
import org.unitarou.util.ArgumentChecker;

public class SgfReal
implements TypedString {
    private static final Log log_s_ = LogFactory.getLog(SgfReal.class);
    private static final Pattern condition_s_ = Pattern.compile("(\\+|-)?\\d+(|\\.\\d+)");
    private final double real_;
    static /* synthetic */ Class class$0;

    public static SgfReal parse(String value) throws TypeParseException {
        Matcher matched = condition_s_.matcher(value);
        if (!matched.matches()) {
            throw new TypeParseException("Bad argument value = " + value);
        }
        try {
            return new SgfReal(Double.parseDouble(matched.group()));
        }
        catch (NumberFormatException e) {
            throw new TypeParseException("Bad argument value = " + value);
        }
    }

    public static SgfReal parseQuietly(String value) {
        try {
            return SgfReal.parse(value);
        }
        catch (TypeParseException e) {
            log_s_.debug("Bad value for parse: " + value, e);
            return null;
        }
    }

    public SgfReal(double real) {
        this.real_ = real;
    }

    public double getReal() {
        return this.real_;
    }

    public boolean acceptable(SgfId sgfId) {
        ArgumentChecker.throwIfNull((Object)sgfId);
        return ValueType.REAL.equals((Object)sgfId.valueType());
    }

    public String getString() {
        return Double.toString(this.real_);
    }

    public boolean isValid(String value) {
        return condition_s_.matcher(value).matches();
    }

    public int compareTo(Object o) {
        SgfReal obj = (SgfReal)o;
        return Double.compare(this.real_, obj.real_);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof SgfReal)) {
            return false;
        }
        SgfReal o = (SgfReal)obj;
        return Double.doubleToLongBits(this.real_) == Double.doubleToLongBits(o.real_);
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.real_);
        return (int)(bits ^ bits >>> 32);
    }
}

