/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.type;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.Sgfs;
import org.unitarou.sgf.ValueType;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.type.TypeParseException;
import org.unitarou.sgf.type.TypedString;
import org.unitarou.sgf.util.SgfPointType;
import org.unitarou.util.ArgumentChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SgfPoint
implements TypedString {
    private static final Log log_s_ = LogFactory.getLog(SgfPoint.class);
    public static final SgfPoint[] EMPTY_ARRAY = new SgfPoint[0];
    public static final int MAX_NEIGHBORS = 4;
    private static final Pattern condition_s_ = Pattern.compile("|(([a-zA-Z])([a-zA-Z]))");
    private static final int ALL_POS = 0;
    private static final int X_POS = 2;
    private static final int Y_POS = 3;
    private static final Pattern compressedCondition_s_ = Pattern.compile("\\s*([a-zA-Z])([a-zA-Z])\\s*:\\s*([a-zA-Z])([a-zA-Z])\\s*");
    private static final int COMP_X1_POS = 1;
    private static final int COMP_Y1_POS = 2;
    private static final int COMP_X2_POS = 3;
    private static final int COMP_Y2_POS = 4;
    private static final SortedMap<Integer, SgfPoint> cache_s_ = new TreeMap<Integer, SgfPoint>();
    private final SgfSize size_;
    private final int x_;
    private final int y_;
    private final SgfPointType condition_;
    private SgfPoint[] neighbors_;
    private int hashCode_;
    private String toString_;
    private String string_;
    static /* synthetic */ Class class$0;

    public static boolean isValid(SgfSize size, String datum) {
        int y;
        ArgumentChecker.throwIfNull((Object)size, (Object)datum);
        Matcher matched = condition_s_.matcher(datum);
        if (!matched.matches()) {
            return false;
        }
        if (matched.group(0).length() == 0) {
            return true;
        }
        int x = Sgfs.fromSgf(matched.group(2).charAt(0));
        SgfPointType condition = size.check(x, y = Sgfs.fromSgf(matched.group(3).charAt(0)));
        return condition.equals((Object)SgfPointType.IN) || condition.equals((Object)SgfPointType.PASS);
    }

    public static SgfPoint parseMove(SgfSize size, String value) throws TypeParseException {
        ArgumentChecker.throwIfNull((Object)size, (Object)value);
        try {
            Matcher matched = condition_s_.matcher(value);
            if (!matched.matches()) {
                throw new TypeParseException("Bad argument value = " + value);
            }
            if (matched.group(0).length() == 0) {
                return SgfPoint.createPass(size);
            }
            int x = Sgfs.fromSgf(matched.group(2).charAt(0));
            int y = Sgfs.fromSgf(matched.group(3).charAt(0));
            return SgfPoint.create(size, x, y);
        }
        catch (IllegalArgumentException e) {
            throw new TypeParseException(e);
        }
    }

    public static SgfPoint parseMoveQuietly(SgfSize size, String value) {
        try {
            return SgfPoint.parseMove(size, value);
        }
        catch (TypeParseException e) {
            log_s_.debug("Can't parse value: " + value, e);
            return null;
        }
    }

    public static SgfPoint[] parse(SgfSize size, String[] values) {
        ArgumentChecker.throwIfNull((Object)size, (Object)values);
        ArrayList<SgfPoint> ret = new ArrayList<SgfPoint>(values.length);
        int i = 0;
        while (i < values.length) {
            try {
                Matcher matched = compressedCondition_s_.matcher(values[i]);
                if (!matched.matches()) {
                    ret.add(SgfPoint.parseMove(size, values[i]));
                } else {
                    int tmp;
                    int x1 = Sgfs.fromSgf(matched.group(1).charAt(0));
                    int y1 = Sgfs.fromSgf(matched.group(2).charAt(0));
                    int x2 = Sgfs.fromSgf(matched.group(3).charAt(0));
                    int y2 = Sgfs.fromSgf(matched.group(4).charAt(0));
                    if (x2 < x1) {
                        tmp = x1;
                        x1 = x2;
                        x2 = tmp;
                    }
                    if (y2 < y1) {
                        tmp = y1;
                        y1 = y2;
                        y2 = tmp;
                    }
                    int x = x1;
                    while (x <= x2) {
                        int y = y1;
                        while (y <= y2) {
                            ret.add(SgfPoint.create(size, x, y));
                            ++y;
                        }
                        ++x;
                    }
                }
            }
            catch (TypeParseException typeParseException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            ++i;
        }
        return ret.toArray(new SgfPoint[ret.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SgfPoint create(SgfSize size, int x, int y) {
        ArgumentChecker.throwIfNull((Object)size);
        SgfPointType condition = size.check(x, y);
        if (condition.equals((Object)SgfPointType.OUT)) {
            throw new IllegalArgumentException("You cannot create a point in outside of board.[Size:" + size + " x:" + x + " y:" + y + "]");
        }
        Integer key = new Integer(size.primaryKey() * 52 * 52 + x + y * 52);
        SortedMap<Integer, SgfPoint> sortedMap = cache_s_;
        synchronized (sortedMap) {
            SgfPoint ret = (SgfPoint)cache_s_.get(key);
            if (ret == null) {
                ret = new SgfPoint(size, x, y);
                cache_s_.put(key, ret);
            }
            return ret;
        }
    }

    public static SgfPoint createPass(SgfSize size) {
        ArgumentChecker.throwIfNull((Object)size);
        int POS = size.height() < 20 && size.width() < 20 ? 20 : 0;
        return SgfPoint.create(size, POS, POS);
    }

    private SgfPoint(SgfSize size, int x, int y) {
        assert (size != null);
        this.condition_ = size.check(x, y);
        this.size_ = size;
        if (this.condition_.equals((Object)SgfPointType.IN)) {
            this.x_ = x;
            this.y_ = y;
        } else {
            this.x_ = 0;
            this.y_ = 0;
        }
        this.neighbors_ = null;
        this.hashCode_ = 0;
        this.toString_ = null;
        this.string_ = null;
    }

    public SgfSize size() {
        return this.size_;
    }

    public int x() {
        return this.x_;
    }

    public int y() {
        return this.y_;
    }

    public SgfPointType condition() {
        return this.condition_;
    }

    public SortedSet<SgfPoint> neighbors() {
        if (this.neighbors_ != null) {
            return Collections.unmodifiableSortedSet(new TreeSet(Arrays.asList(this.neighbors_)));
        }
        ArrayList<SgfPoint> list = new ArrayList<SgfPoint>(4);
        if (1 < this.x_) {
            list.add(SgfPoint.create(this.size_, this.x_ - 1, this.y_));
        }
        if (this.x_ < this.size_.width()) {
            list.add(SgfPoint.create(this.size_, this.x_ + 1, this.y_));
        }
        if (1 < this.y_) {
            list.add(SgfPoint.create(this.size_, this.x_, this.y_ - 1));
        }
        if (this.y_ < this.size_.height()) {
            list.add(SgfPoint.create(this.size_, this.x_, this.y_ + 1));
        }
        this.neighbors_ = list.toArray(new SgfPoint[list.size()]);
        return Collections.unmodifiableSortedSet(new TreeSet(Arrays.asList(this.neighbors_)));
    }

    @Override
    public boolean acceptable(SgfId sgfId) {
        ArgumentChecker.throwIfNull((Object)sgfId);
        return ValueType.POINT.equals((Object)sgfId.valueType()) || ValueType.MOVE.equals((Object)sgfId.valueType());
    }

    @Override
    public String getString() {
        if (this.string_ != null) {
            return this.string_;
        }
        this.string_ = this.x_ == 0 ? "" : new String(new char[]{Sgfs.toSgf(this.x_), Sgfs.toSgf(this.y_)});
        return this.string_;
    }

    @Override
    public int compareTo(Object o) {
        SgfPoint obj = (SgfPoint)o;
        int comp = this.size_.compareTo(obj.size_);
        return comp != 0 ? comp : this.x_ + this.y_ * 52 - (obj.x_ + obj.y_ * 52);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        SgfPoint p = (SgfPoint)obj;
        return this.x_ == p.x_ && this.y_ == p.y_ && this.size_.equals(p.size_);
    }

    public int hashCode() {
        if (this.hashCode_ == 0) {
            this.hashCode_ = this.x_ + this.y_ * 52;
        }
        return this.hashCode_;
    }

    public String toString() {
        if (this.toString_ == null) {
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            sb.append(this.x_);
            sb.append(',');
            sb.append(this.y_);
            sb.append(']');
            sb.append(this.size_);
            this.toString_ = sb.toString();
        }
        return this.toString_;
    }
}

