/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.type;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.ValueType;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.type.TypeParseException;
import org.unitarou.sgf.type.TypedString;
import org.unitarou.util.ArgumentChecker;

public class SgfLine
implements TypedString {
    private static final Log log_s_ = LogFactory.getLog(SgfLine.class);
    private static final Pattern condition_s_ = Pattern.compile("([a-zA-Z]{2})\\s*:\\s*([a-zA-Z]{2})");
    private static final int START_POS = 1;
    private static final int END_POS = 2;
    private final SgfPoint start_;
    private final SgfPoint end_;
    static /* synthetic */ Class class$0;

    public static SgfLine parse(SgfSize size, String string) throws TypeParseException {
        Matcher matched = condition_s_.matcher(string);
        if (!matched.matches()) {
            throw new TypeParseException("Bad argument value = " + string);
        }
        SgfLine ret = new SgfLine(SgfPoint.parseMove(size, matched.group(1)), SgfPoint.parseMove(size, matched.group(2)));
        return ret;
    }

    public static SgfLine parseQuietly(SgfSize size, String string) {
        try {
            return SgfLine.parse(size, string);
        }
        catch (TypeParseException e) {
            log_s_.debug("Parse failure: ", e);
            return null;
        }
    }

    public SgfLine(SgfPoint start, SgfPoint end) {
        this.start_ = start;
        this.end_ = end;
    }

    public SgfPoint getStart() {
        return this.start_;
    }

    public SgfPoint getEnd() {
        return this.end_;
    }

    public boolean acceptable(SgfId sgfId) {
        ArgumentChecker.throwIfNull((Object)sgfId);
        return ValueType.CPOINT.equals((Object)sgfId.valueType());
    }

    public String getString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.start_.getString());
        sb.append(':');
        sb.append(this.end_.getString());
        return sb.toString();
    }

    public boolean isValid(String value) {
        return value != null ? condition_s_.matcher(value).matches() : false;
    }

    public int compareTo(Object o) {
        SgfLine obj = (SgfLine)o;
        return (this.start_.hashCode() - obj.start_.hashCode()) * 52 * 53 + (this.end_.hashCode() - obj.end_.hashCode());
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof SgfLine)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        SgfLine o = (SgfLine)obj;
        return this.start_.equals(o.start_) && this.end_.equals(o.end_);
    }

    public int hashCode() {
        return this.start_.hashCode() * 52 * 53 + this.end_.hashCode();
    }
}

