/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.type;

import java.nio.charset.Charset;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.TypedString;
import org.unitarou.util.ArgumentChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SgfCharset
implements TypedString<SgfCharset> {
    private static final Log log_s_ = LogFactory.getLog(SgfCharset.class);
    private Charset charset_;
    static /* synthetic */ Class class$0;

    public static SgfCharset parse(String value) {
        return new SgfCharset(value);
    }

    public SgfCharset(Charset charset) {
        ArgumentChecker.throwIfNull((Object)charset);
        this.charset_ = charset;
    }

    private SgfCharset(String value) {
        try {
            this.charset_ = Charset.forName(value);
        }
        catch (IllegalArgumentException e) {
            this.charset_ = Charset.defaultCharset();
            log_s_.warn(String.valueOf(value) + " is not a valid charset name. Use default chaset:" + this.charset_, e);
        }
    }

    public Charset getCharset() {
        return this.charset_;
    }

    @Override
    public boolean acceptable(SgfId sgfId) {
        ArgumentChecker.throwIfNull((Object)sgfId);
        return sgfId.equals(SgfId.CHARSET);
    }

    @Override
    public String getString() {
        return this.charset_.name();
    }

    @Override
    public int compareTo(SgfCharset o) {
        return this.charset_.compareTo(o.charset_);
    }
}

