/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.type;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.SgfNumber;
import org.unitarou.sgf.type.TypeParseException;
import org.unitarou.util.ArgumentChecker;

public class ProblemProperties
extends SgfNumber {
    private static final Log log_s_ = LogFactory.getLog(ProblemProperties.class);
    private static final Pattern condition_s_ = Pattern.compile("\\d+");
    private final EnumSet<Flag> enumSet_;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static ProblemProperties parsePp(String value) throws TypeParseException {
        ArgumentChecker.throwIfNull((Object)value);
        Matcher matched = condition_s_.matcher(value);
        if (!matched.matches()) {
            throw new TypeParseException("Bad argument value = " + value);
        }
        return new ProblemProperties(Integer.parseInt(matched.group()));
    }

    public static ProblemProperties parsePpQuietly(String value) {
        ArgumentChecker.throwIfNull((Object)value);
        try {
            return ProblemProperties.parsePp(value);
        }
        catch (TypeParseException e) {
            log_s_.debug("Unknown value for ProblemProperties: " + value, e);
            return new ProblemProperties(0);
        }
    }

    public ProblemProperties(int number) {
        super(number);
        this.enumSet_ = EnumSet.noneOf(Flag.class);
        EnumSet<Flag> set = EnumSet.allOf(Flag.class);
        for (Flag flag : set) {
            if ((flag.value_ & number) == 0) continue;
            this.enumSet_.add(flag);
        }
    }

    public ProblemProperties(Flag ... flags) {
        super(Flag.toIntValue(flags));
        this.enumSet_ = EnumSet.copyOf(Arrays.asList(flags));
    }

    public boolean acceptable(SgfId sgfId) {
        ArgumentChecker.throwIfNull((Object)sgfId);
        return SgfId.PROBLEM_PROPERTIES.equals(sgfId);
    }

    public boolean contains(Flag flag) {
        ArgumentChecker.throwIfNull((Object)flag);
        return this.enumSet_.contains((Object)flag);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Flag {
        SHOW_HINT(1),
        SHUFFLE(2),
        RETRYABLE(4),
        TIME_LIMIT(8),
        MIRROR_ROTATE(16),
        SHOW_ENDPOINT(32);

        private final int value_;
        private final MessageResource messageResource_;

        public static int toIntValue(Flag ... flags) {
            int ret = 0;
            Flag[] flagArray = flags;
            int n = 0;
            int n2 = flagArray.length;
            while (n < n2) {
                Flag flag = flagArray[n];
                ret |= flag.value_;
                ++n;
            }
            return ret;
        }

        private Flag(int value) {
            this.value_ = value;
            this.messageResource_ = new MessageResource(((Object)((Object)this)).getClass(), String.valueOf(value));
        }

        public int getValue() {
            return this.value_;
        }

        public String getDisplayName() {
            return this.messageResource_.get();
        }
    }
}

