/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.type;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.type.SimpleText;
import org.unitarou.sgf.type.TypeParseException;
import org.unitarou.sgf.type.TypedString;
import org.unitarou.util.ArgumentChecker;

public class Label
implements TypedString {
    private static final Log log_s_ = LogFactory.getLog(Label.class);
    private static final Pattern condition_s_ = Pattern.compile("([a-zA-Z]{2})\\s*:(.*)");
    private static final int POSITION_POS = 1;
    private static final int LABEL_POS = 2;
    private final SgfPoint point_;
    private final SimpleText label_;
    static /* synthetic */ Class class$0;

    public static String[] parseString(String value) throws TypeParseException {
        Matcher matched = condition_s_.matcher(value);
        if (!matched.matches()) {
            throw new TypeParseException("Bad argument value='" + value + '\'');
        }
        return new String[]{matched.group(1), matched.group(2)};
    }

    public static Label parse(SgfSize size, String value) throws TypeParseException {
        ArgumentChecker.throwIfNull((Object)size, (Object)value);
        String[] parsed = Label.parseString(value);
        return new Label(SgfPoint.parseMove(size, parsed[0]), SimpleText.parse(parsed[1]));
    }

    public static Label parseQuietly(SgfSize size, String value) {
        try {
            return Label.parse(size, value);
        }
        catch (TypeParseException e) {
            log_s_.debug("Bad value for parse: " + value, e);
            return null;
        }
    }

    public Label(SgfPoint point, SimpleText simpleText) {
        this.point_ = point;
        this.label_ = simpleText;
    }

    public boolean acceptable(SgfId sgfId) {
        ArgumentChecker.throwIfNull((Object)sgfId);
        return SgfId.LABEL.equals(sgfId);
    }

    public String getString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.point_.getString());
        sb.append(':');
        sb.append(this.label_.getString());
        return sb.toString();
    }

    public SgfPoint getPoint() {
        return this.point_;
    }

    public SimpleText getLabel() {
        return this.label_;
    }

    public boolean isValid(String value) {
        return value != null ? condition_s_.matcher(value).matches() : false;
    }

    public int compareTo(Object o) {
        Label obj = (Label)o;
        return this.point_.compareTo(obj.point_);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Label)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        Label o = (Label)obj;
        return this.point_.equals(o.point_);
    }

    public int hashCode() {
        return this.point_.hashCode();
    }
}

