/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.type;

import java.util.EnumSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.lang.NameDisplayable;
import org.unitarou.ml.Messages;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.TypeParseException;
import org.unitarou.sgf.type.TypedString;
import org.unitarou.util.ArgumentChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GameType
extends Enum<GameType>
implements TypedString<GameType>,
NameDisplayable {
    public static final /* enum */ GameType GAME = new GameType("1");
    public static final /* enum */ GameType PROBLEM = new GameType("3");
    public static final /* enum */ GameType DRILL = new GameType("4");
    private static final Log log_s_;
    private static final Messages messages_s_;
    private static final Pattern condition_s_;
    private static final int POS = 0;
    private final String typeName_;
    private final String displayNameKey_;
    private static final /* synthetic */ GameType[] ENUM$VALUES;
    static /* synthetic */ Class class$0;

    static {
        ENUM$VALUES = new GameType[]{GAME, PROBLEM, DRILL};
        log_s_ = LogFactory.getLog(GameType.class);
        messages_s_ = Messages.createByPackage(GameType.class);
        condition_s_ = Pattern.compile("1|3|4");
    }

    public static GameType parse(String value) throws TypeParseException {
        ArgumentChecker.throwIfNull((Object)value);
        Matcher matched = condition_s_.matcher(value);
        if (!matched.matches()) {
            throw new TypeParseException("Bad argument value = " + value);
        }
        String gameType = matched.group(0);
        GameType[] gameTypeArray = GameType.values();
        int n = 0;
        int n2 = gameTypeArray.length;
        while (n < n2) {
            GameType type = gameTypeArray[n];
            if (type.typeName_.equals(gameType)) {
                return type;
            }
            ++n;
        }
        assert (false);
        throw new TypeParseException();
    }

    public static GameType parseQuietly(String value, GameType def) {
        ArgumentChecker.throwIfNull((Object)value);
        try {
            return GameType.parse(value);
        }
        catch (TypeParseException e) {
            log_s_.debug("Unknown value for GameType: " + value, e);
            return def;
        }
    }

    public static EnumSet<GameType> parseSetQuietly(String value, EnumSet<GameType> def) {
        ArgumentChecker.throwIfNull((Object)value, def);
        EnumSet<GameType> ret = EnumSet.noneOf(GameType.class);
        int i = 0;
        while (i < value.length()) {
            try {
                char c = value.charAt(i);
                ret.add(GameType.parse(String.valueOf(c)));
            }
            catch (TypeParseException e) {
                log_s_.debug("Unknown value for GameType: " + value, e);
            }
            ++i;
        }
        return ret.isEmpty() ? def : ret;
    }

    private GameType(String typeName) {
        ArgumentChecker.throwIfNull((Object)typeName);
        this.typeName_ = typeName;
        this.displayNameKey_ = Messages.createKey(this.getClass(), this.typeName_);
    }

    @Override
    public boolean acceptable(SgfId sgfId) {
        ArgumentChecker.throwIfNull((Object)sgfId);
        return SgfId.GAME_TYPE.equals(sgfId);
    }

    @Override
    public String getString() {
        return this.typeName_;
    }

    public String toString() {
        return this.displayName();
    }

    @Override
    public String displayName() {
        return messages_s_.get(this.displayNameKey_);
    }

    public static final GameType[] values() {
        GameType[] gameTypeArray = ENUM$VALUES;
        int n = gameTypeArray.length;
        GameType[] gameTypeArray2 = new GameType[n];
        System.arraycopy(ENUM$VALUES, 0, gameTypeArray2, 0, n);
        return gameTypeArray2;
    }

    public static final GameType valueOf(String string) {
        GameType[] gameTypeArray = ENUM$VALUES;
        int n = ENUM$VALUES.length;
        while (--n >= 0) {
            GameType gameType = gameTypeArray[n];
            if (!string.equals(gameType.name())) continue;
            return gameType;
        }
        throw new IllegalArgumentException(string);
    }
}

