/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.type;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.lang.NameDisplayable;
import org.unitarou.ml.Messages;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.TypeParseException;
import org.unitarou.sgf.type.TypedString;
import org.unitarou.util.ArgumentChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum FileFormat implements TypedString<FileFormat>,
NameDisplayable
{
    VERSION_1(1),
    VERSION_2(2),
    VERSION_3(3),
    VERSION_4(4);

    private static Log log_s_;
    private static final Pattern condition_s_;
    private static final int POS = 0;
    private final String string_;
    static /* synthetic */ Class class$0;

    static {
        log_s_ = LogFactory.getLog(FileFormat.class);
        condition_s_ = Pattern.compile("1|2|3|4");
    }

    public static FileFormat parse(String value) throws TypeParseException {
        Matcher matched = condition_s_.matcher(value);
        if (!matched.matches()) {
            throw new TypeParseException("Bad argument value = " + value);
        }
        String ff = matched.group(0);
        FileFormat[] fileFormatArray = FileFormat.values();
        int n = 0;
        int n2 = fileFormatArray.length;
        while (n < n2) {
            FileFormat fileFormat = fileFormatArray[n];
            if (fileFormat.string_.equals(ff)) {
                return fileFormat;
            }
            ++n;
        }
        log_s_.info("Unknown FileFormat: " + ff + ". Use FF[4] instead");
        return VERSION_4;
    }

    private FileFormat(int id) {
        this.string_ = String.valueOf(id);
    }

    @Override
    public String getString() {
        return this.string_;
    }

    @Override
    public boolean acceptable(SgfId sgfId) {
        ArgumentChecker.throwIfNull((Object)sgfId);
        return SgfId.FILE_FORMAT.equals(sgfId);
    }

    public String toString() {
        return this.displayName();
    }

    @Override
    public String displayName() {
        Messages messages = Messages.createByPackage(this.getClass());
        return messages.get(Messages.createKey(this.getClass(), this.string_));
    }
}

