/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.parser;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.parser.SgfParserCore;
import org.unitarou.sgf.parser.SgfParserException;
import org.unitarou.sgf.parser.SgfParserLogger;
import org.unitarou.util.ArgumentChecker;

public class SgfParser {
    private static final Log log_s_ = LogFactory.getLog(SgfParser.class);
    private static final MessageResource SP_DEFAULT_DECODE_CHARSET = new MessageResource(SgfParser.class, "spDefaultDecodeCharset");
    public static final Charset DEFAULT_DECODE_CHARSET;
    private static final MessageResource NT_INPUT_TERMINATED;
    private final SgfParserCore sgfParserBase_ = new SgfParserCore();
    private Charset defaultCharset_ = DEFAULT_DECODE_CHARSET;
    static /* synthetic */ Class class$0;

    static {
        NT_INPUT_TERMINATED = new MessageResource(SgfParser.class, "ntInputTerminated");
        Charset charset = null;
        try {
            charset = Charset.forName(SP_DEFAULT_DECODE_CHARSET.get());
        }
        catch (IllegalArgumentException e) {
            log_s_.warn("Unknown charset:" + SP_DEFAULT_DECODE_CHARSET.get());
            charset = Charset.defaultCharset();
        }
        DEFAULT_DECODE_CHARSET = charset;
    }

    public void setDefaultCharset(Charset defaultCharset) {
        ArgumentChecker.throwIfNull((Object)defaultCharset);
        this.defaultCharset_ = defaultCharset;
    }

    public Charset getDefaultCharset() {
        return this.defaultCharset_;
    }

    @Deprecated
    public Collection parse(Reader reader) throws SgfParserException {
        ArgumentChecker.throwIfNull((Object)reader);
        this.sgfParserBase_.setParserLogger(new SgfParserLogger());
        this.sgfParserBase_.setReader(reader);
        try {
            this.sgfParserBase_.setInputTerminated(false);
            Collection collection = new Collection();
            while (this.sgfParserBase_.parseCollection(collection)) {
            }
            if (this.sgfParserBase_.isInputTerminated()) {
                this.sgfParserBase_.writeWarningLog(NT_INPUT_TERMINATED, new Object());
            }
            collection.setParserLog(this.sgfParserBase_.getParserLogger());
            return collection;
        }
        catch (IOException e) {
            throw new SgfParserException(e);
        }
    }

    public Collection parse(String string) throws SgfParserException {
        ArgumentChecker.throwIfNull((Object)string);
        this.sgfParserBase_.setParserLogger(new SgfParserLogger());
        ByteBuffer buffer = ByteBuffer.wrap(string.getBytes());
        return this.parseImpl(buffer);
    }

    public Collection parse(File file) throws SgfParserException {
        ArgumentChecker.throwIfNull((Object)file);
        this.sgfParserBase_.setParserLogger(new SgfParserLogger());
        return this.parseImpl(file);
    }

    /*
     * Loose catch block
     */
    private Collection parseImpl(File file) throws SgfParserException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            FileChannel fileChannel = fileInputStream.getChannel();
            if (Integer.MAX_VALUE < fileChannel.size()) {
                throw new SgfParserException("Can't open file because of large size.");
            }
            ByteBuffer byteBuffer = ByteBuffer.allocate((int)fileChannel.size());
            fileChannel.read(byteBuffer);
            Collection collection = this.parseImpl(byteBuffer);
            collection.setFile(file);
            Collection collection2 = collection;
            IOUtils.closeQuietly(fileInputStream);
            return collection2;
        }
        catch (IOException e) {
            throw new SgfParserException(e);
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fileInputStream);
                    throw throwable;
                }
            }
        }
    }

    private Collection parseImpl(ByteBuffer byteBuffer) throws SgfParserException {
        ArgumentChecker.throwIfNull((Object)byteBuffer);
        this.sgfParserBase_.setByteBuffer(byteBuffer, this.defaultCharset_);
        try {
            this.sgfParserBase_.setInputTerminated(false);
            Collection collection = new Collection();
            while (this.sgfParserBase_.parseCollection(collection)) {
            }
            if (this.sgfParserBase_.isInputTerminated()) {
                this.sgfParserBase_.writeWarningLog(NT_INPUT_TERMINATED, new Object());
            }
            collection.setParserLog(this.sgfParserBase_.getParserLogger());
            return collection;
        }
        catch (IOException e) {
            throw new SgfParserException(e);
        }
    }
}

