/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.parser;

import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.Sgfs;
import org.unitarou.sgf.Value;
import org.unitarou.sgf.type.SgfCharset;
import org.unitarou.util.ArgumentChecker;

public class SgfFormatter {
    private static final Log log_s_ = LogFactory.getLog(SgfFormatter.class);
    private static final MessageResource SP_DEFAULT_ENCODE_CHARSET = new MessageResource(SgfFormatter.class, "spDefaultEncodeCharset");
    public static final Charset DEFAULT_ENCODE_CHARSET;
    private boolean writeRegularId_ = false;
    private StringWriter writer_;
    static /* synthetic */ Class class$0;

    static {
        Charset charset = null;
        try {
            charset = Charset.forName(SP_DEFAULT_ENCODE_CHARSET.get());
            if (!charset.canEncode()) {
                charset = Charset.defaultCharset();
                log_s_.warn("Bad argument, needs encodable charset:" + SP_DEFAULT_ENCODE_CHARSET.get() + ". Use default charset" + charset.displayName());
            }
        }
        catch (IllegalArgumentException e) {
            log_s_.warn("Unknown charset:" + SP_DEFAULT_ENCODE_CHARSET.get());
            charset = Charset.defaultCharset();
        }
        DEFAULT_ENCODE_CHARSET = charset;
    }

    public ByteBuffer format(Collection collection) {
        ArgumentChecker.throwIfNull((Object)collection);
        ArrayList<ByteBuffer> byteBuffers = new ArrayList<ByteBuffer>(collection.size());
        int totalByte = 0;
        int i = 0;
        while (i < collection.size()) {
            this.writer_ = new StringWriter();
            RootGameTree rootTree = collection.get(i);
            if (rootTree.getSequence().size() != 0) {
                this.format(rootTree);
                this.writer_.flush();
                SgfCharset charset = rootTree.getSgfCharset(DEFAULT_ENCODE_CHARSET);
                ByteBuffer byteBuffer = charset.getCharset().encode(this.writer_.toString());
                byteBuffers.add(byteBuffer);
                totalByte += byteBuffer.limit();
            }
            ++i;
        }
        ByteBuffer ret = ByteBuffer.allocate(totalByte);
        for (ByteBuffer buffer : byteBuffers) {
            ret.put(buffer);
        }
        ret.rewind();
        return ret;
    }

    public String formatAsString(Collection collection) {
        ArgumentChecker.throwIfNull((Object)collection);
        this.writer_ = new StringWriter();
        int i = 0;
        while (i < collection.size()) {
            RootGameTree rootTree = collection.get(i);
            if (rootTree.getSequence().size() != 0) {
                this.format(rootTree);
            }
            ++i;
        }
        this.writer_.flush();
        return this.writer_.toString();
    }

    private void format(GameTree gameTree) {
        this.writer_.write(gameTree.getOpenUtr());
        this.writer_.write(40);
        Node[] nodes = gameTree.getSequence().getNodes();
        int i = 0;
        while (i < nodes.length) {
            this.format(nodes[i]);
            ++i;
        }
        GameTree[] children = gameTree.getChildren();
        int i2 = 0;
        while (i2 < children.length) {
            this.format(children[i2]);
            ++i2;
        }
        this.writer_.write(41);
        this.writer_.write(gameTree.getCloseUtr());
    }

    private void format(Node node) {
        this.writer_.write(node.getOpenUtr());
        this.writer_.write(59);
        Property[] properties = node.getProperties();
        int i = 0;
        while (i < properties.length) {
            this.format(properties[i]);
            ++i;
        }
    }

    private void format(Property property) {
        this.writer_.write(property.getOpenUtr());
        this.writer_.write(this.writeRegularId_ ? property.getId() : property.getEntireId());
        Value[] values = property.value().getValues();
        if (property.sgfId().equals(SgfId.INPUT_FILES)) {
            int i = 0;
            while (i < values.length) {
                this.writer_.write(values[i].getOpenUtr());
                this.writer_.write(91);
                this.writer_.write(Sgfs.escaporIfForStore(values[i].getString()));
                this.writer_.write(93);
                ++i;
            }
        } else {
            int i = 0;
            while (i < values.length) {
                this.writer_.write(values[i].getOpenUtr());
                this.writer_.write(91);
                this.writer_.write(Sgfs.escapeForStore(values[i].getString()));
                this.writer_.write(93);
                ++i;
            }
        }
        this.writer_.write(property.getCloseUtr());
    }
}

