/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.cmd;

import org.unitarou.cmd.AbstractCommand;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.util.ArgumentChecker;

public class RemoveGameTree
extends AbstractCommand {
    private final GameTree parent_;
    private final GameTree target_;
    private GameTree[] children_;
    private Node extensionPoint_;

    public RemoveGameTree(GameTree parent, GameTree target) {
        ArgumentChecker.throwIfNull((Object)parent, (Object)target);
        this.parent_ = parent;
        this.target_ = target;
        this.children_ = null;
        this.extensionPoint_ = null;
    }

    public void execute() {
        super.execute();
        this.children_ = this.parent_.getChildren();
        this.parent_.removeGameTree(this.target_);
        GameTree[] newChildren = this.parent_.getChildren();
        if (newChildren.length != 1) {
            this.extensionPoint_ = null;
        } else {
            this.extensionPoint_ = this.parent_.getSequence().getLast();
            for (Node node : newChildren[0].getSequence()) {
                this.parent_.getSequence().addLast(node);
            }
            this.parent_.clearGameTree();
            GameTree[] gameTreeArray = newChildren[0].getChildren();
            int n = 0;
            int n2 = gameTreeArray.length;
            while (n < n2) {
                GameTree gameTree = gameTreeArray[n];
                this.parent_.addGameTree(gameTree);
                ++n;
            }
        }
    }

    public void undo() {
        super.undo();
        if (this.extensionPoint_ != null) {
            Node last = this.parent_.getSequence().getLast();
            while (last != this.extensionPoint_) {
                last = this.parent_.getSequence().removeLast();
            }
            this.parent_.getSequence().addLast(last);
            this.extensionPoint_ = null;
        }
        this.parent_.clearGameTree();
        int i = 0;
        while (i < this.children_.length) {
            this.parent_.addGameTree(this.children_[i]);
            ++i;
        }
        this.children_ = null;
    }
}

