/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.cmd;

import org.unitarou.cmd.AbstractCommand;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Sequence;
import org.unitarou.util.ArgumentChecker;

public class InsertNode
extends AbstractCommand {
    private final GameTree tree_;
    private final Node insertPoint_;
    private final Node newNode_;

    public InsertNode(GameTree tree, Node insertPoint, Node newNode) {
        ArgumentChecker.throwIfNull((Object)tree, (Object)insertPoint, (Object)newNode);
        if (!this.contain(tree.getSequence(), insertPoint)) {
            throw new IllegalArgumentException("insertPoint doesn't contain tree!");
        }
        this.tree_ = tree;
        this.insertPoint_ = insertPoint;
        this.newNode_ = newNode;
    }

    private boolean contain(Sequence sequence, Node targetNode) {
        ArgumentChecker.throwIfNull((Object)sequence, (Object)targetNode);
        for (Node node : sequence) {
            if (node != targetNode) continue;
            return true;
        }
        return false;
    }

    public void execute() {
        super.execute();
        this.tree_.getSequence().insert(this.newNode_, this.insertPoint_);
    }

    public void undo() {
        super.undo();
        this.tree_.getSequence().remove(this.newNode_);
    }
}

