/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.cmd;

import org.unitarou.cmd.AbstractCommand;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;

class CreateGameTreeImpl
extends AbstractCommand {
    private final GameTree parent_;
    private final Node extensionPoint_;
    private final GameTree child_;

    CreateGameTreeImpl(GameTree parent, Node extensionPoint, GameTree child) {
        if (parent == null || extensionPoint == null || child == null) {
            throw new NullPointerException("Arguments must not be null.  parent = " + parent + " extensionPoint = " + extensionPoint + " child = " + child);
        }
        this.parent_ = parent;
        this.extensionPoint_ = extensionPoint;
        this.child_ = child;
    }

    public void execute() {
        super.execute();
        GameTree mainstream = new GameTree();
        Node last = this.parent_.getSequence().removeLast();
        while (last != this.extensionPoint_) {
            mainstream.getSequence().addFirst(last);
            last = this.parent_.getSequence().removeLast();
        }
        this.parent_.getSequence().addLast(last);
        GameTree[] children = this.parent_.getChildren();
        int i = 0;
        while (i < children.length) {
            mainstream.addGameTree(children[i]);
            ++i;
        }
        this.parent_.clearGameTree();
        this.parent_.addGameTree(mainstream);
        this.parent_.addGameTree(this.child_);
    }

    public void undo() {
        super.undo();
        GameTree[] children = this.parent_.getChildren();
        for (Node node : children[0].getSequence()) {
            this.parent_.getSequence().addLast(node);
        }
        this.parent_.clearGameTree();
        GameTree[] pastChildren = children[0].getChildren();
        int i = 0;
        while (i < pastChildren.length) {
            this.parent_.addGameTree(pastChildren[i]);
            ++i;
        }
    }
}

