/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.cmd;

import org.unitarou.cmd.AbstractCommand;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Property;
import org.unitarou.util.ArgumentChecker;

public class AddProperty
extends AbstractCommand {
    private final Node node_;
    private final Property property_;
    private Property lastProperty_;

    public AddProperty(Node node, Property property) {
        ArgumentChecker.throwIfNull((Object)node, (Object)property);
        this.node_ = node;
        this.property_ = property;
    }

    public void execute() {
        super.execute();
        this.lastProperty_ = this.node_.getProperty(this.property_.sgfId());
        this.node_.addProperty(this.property_);
    }

    public void undo() {
        super.undo();
        Property removed = this.node_.removeProperty(this.property_.getId());
        if (this.lastProperty_ != null) {
            this.node_.addProperty(this.lastProperty_);
            this.lastProperty_ = null;
        }
        if (!this.property_.equals(removed)) {
            throw new IllegalStateException("Cannot remove addition node. removed = " + removed + " additionNode = " + this.node_);
        }
    }
}

