/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.cmd;

import org.unitarou.cmd.AbstractCommand;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;

public class AddNode
extends AbstractCommand {
    private final GameTree tree_;
    private final Node newNode_;

    public AddNode(GameTree tree, Node newNode) {
        if (tree == null || newNode == null) {
            throw new NullPointerException("Arguments must not be null. tree = " + tree + " newNode = " + newNode);
        }
        this.tree_ = tree;
        this.newNode_ = newNode;
    }

    public void execute() {
        super.execute();
        this.tree_.getSequence().addLast(this.newNode_);
    }

    public void undo() {
        super.undo();
        Node lastNode = this.tree_.getSequence().removeLast();
        if (!this.newNode_.equals(lastNode)) {
            throw new IllegalStateException("Cannot remove addition node. lastNode = " + lastNode + "additionNode = " + this.newNode_);
        }
    }
}

