/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.cmd;

import org.unitarou.cmd.AbstractCommand;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Sequence;

public class AddGameTree
extends AbstractCommand {
    private final GameTree target_;
    private final GameTree child_;
    private Node additionPoint_;
    private boolean appendAsSequence_;

    public AddGameTree(GameTree target, GameTree child) {
        if (target == null || child == null) {
            throw new NullPointerException("Arguments must not be null. target = " + target + " child = " + child);
        }
        this.target_ = target;
        this.child_ = child;
        this.additionPoint_ = null;
        this.appendAsSequence_ = false;
    }

    public void execute() {
        super.execute();
        if (this.target_.getChildren().length > 0) {
            this.target_.addGameTree(this.child_);
        } else {
            Sequence sequence = this.target_.getSequence();
            this.appendAsSequence_ = true;
            this.additionPoint_ = sequence.getLast();
            for (Node node : this.child_.getSequence()) {
                this.target_.getSequence().addLast(node);
            }
            GameTree[] children = this.child_.getChildren();
            int i = 0;
            while (i < children.length) {
                this.target_.addGameTree(children[i]);
                ++i;
            }
        }
    }

    public void undo() {
        super.undo();
        if (!this.appendAsSequence_) {
            this.target_.removeGameTree(this.child_);
        } else {
            Node last = this.target_.getSequence().removeLast();
            while (last != this.additionPoint_) {
                last = this.target_.getSequence().removeLast();
            }
            if (this.additionPoint_ != null) {
                this.target_.getSequence().addLast(last);
            }
            this.target_.clearGameTree();
            this.additionPoint_ = null;
        }
    }
}

