/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf;

import java.io.File;
import java.text.StringCharacterIterator;
import org.unitarou.util.ArgumentChecker;

public final class Sgfs {
    public static final char GAME_TREE_START_MARK = '(';
    public static final char GAME_TREE_END_MARK = ')';
    public static final char NODE_START_MARK = ';';
    public static final char VALUE_START_MARK = '[';
    public static final char VALUE_END_MARK = ']';
    public static final char ESCAPE_SOFT_LINE_BREAK = '\\';
    public static final char COMPOSE_SEPARATOR = ':';
    public static final int ST_CHILDLEN = 0;
    public static final int ST_SIBLINGS = 1;
    public static final char IF_FILE_SEPARATOR_ESCAPE_MARK = '/';
    public static final String EXTENSION = "sgf";

    public static String unescapeTextForRead(String datum) {
        ArgumentChecker.throwIfNull((Object)datum);
        StringBuilder sb = new StringBuilder(datum.length());
        StringCharacterIterator iter = new StringCharacterIterator(datum);
        char c = iter.first();
        while (c != '\uffff') {
            if (c != '\\') {
                if (c == '\r' || c == '\n' || !Character.isWhitespace(c)) {
                    sb.append(c);
                } else {
                    sb.append(' ');
                }
            } else {
                c = iter.next();
                if ('\r' == c) {
                    c = iter.next();
                    if (c == '\uffff') break;
                    if ('\n' != c) {
                        sb.append(c);
                    }
                } else if ('\n' == c) {
                    c = iter.next();
                    if (c == '\uffff') break;
                    if ('\r' != c) {
                        sb.append(c);
                    }
                } else {
                    sb.append(c);
                }
            }
            c = iter.next();
        }
        return sb.toString();
    }

    public static String unescapeSimpleTextForRead(String datum) {
        ArgumentChecker.throwIfNull((Object)datum);
        StringBuilder sb = new StringBuilder(datum.length());
        StringCharacterIterator iter = new StringCharacterIterator(datum);
        char c = iter.first();
        while (c != '\uffff') {
            if (c != '\\') {
                if (!Character.isWhitespace(c)) {
                    sb.append(c);
                } else {
                    sb.append(' ');
                }
            } else {
                c = iter.next();
                if ('\r' == c) {
                    c = iter.next();
                    if (c == '\uffff') break;
                    if ('\n' != c) {
                        sb.append(c);
                    }
                } else if ('\n' == c) {
                    c = iter.next();
                    if (c == '\uffff') break;
                    if ('\r' != c) {
                        sb.append(c);
                    }
                } else {
                    sb.append(c);
                }
            }
            c = iter.next();
        }
        return sb.toString();
    }

    public static String escapeForStore(String text) {
        ArgumentChecker.throwIfNull((Object)text);
        StringBuilder sb = new StringBuilder(text.length());
        StringCharacterIterator iter = new StringCharacterIterator(text);
        char c = iter.first();
        while (c != '\uffff') {
            switch (c) {
                case ']': {
                    sb.append('\\');
                    sb.append(c);
                    break;
                }
                case '\\': {
                    char nc = iter.next();
                    if (nc != '\n' && nc != '\r') {
                        sb.append('\\');
                    }
                    iter.previous();
                    sb.append(c);
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            c = iter.next();
        }
        return sb.toString();
    }

    public static String unescapeIfForRead(String ifValue) {
        ArgumentChecker.throwIfNull((Object)ifValue);
        return ifValue.replace('/', File.separatorChar);
    }

    public static String escaporIfForStore(String ifValue) {
        ArgumentChecker.throwIfNull((Object)ifValue);
        return ifValue.replace(File.separatorChar, '/');
    }

    public static boolean isValidId(String id) {
        if (id == null || id.length() == 0 || 2 < id.length()) {
            return false;
        }
        int i = 0;
        while (i < id.length()) {
            char c = id.charAt(i);
            if (c < 'A' || 'Z' < c) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isValidEntireId(String entireId) {
        if (entireId == null || entireId.length() == 0) {
            return false;
        }
        boolean containsUpperLetter = false;
        int i = 0;
        while (i < entireId.length()) {
            char c = entireId.charAt(i);
            if ('A' <= c && c <= 'Z') {
                containsUpperLetter = true;
            } else if (c < 'a' || 'z' < c) {
                return false;
            }
            ++i;
        }
        return containsUpperLetter;
    }

    public static String convertRegularId(String entireId) {
        ArgumentChecker.throwIfNull((Object)entireId);
        if (entireId.length() == 0) {
            return entireId;
        }
        StringBuilder ret = new StringBuilder();
        int i = 0;
        while (i < entireId.length()) {
            char c = entireId.charAt(i);
            if ('A' <= c && c <= 'Z') {
                ret.append(c);
                if (ret.length() == 2) break;
            }
            ++i;
        }
        assert (ret.length() > 0 && ret.length() <= 2);
        return ret.toString();
    }

    public static int fromSgf(char c) {
        if ('a' <= c && c <= 'z' || 'A' <= c && c <= 'Z') {
            return c <= 'Z' ? c - 65 + 27 : c - 97 + 1;
        }
        throw new IllegalArgumentException("c is out of range: " + c);
    }

    public static char toSgf(int position) {
        if (position <= 0 || 52 < position) {
            throw new IllegalArgumentException("position is out of range:" + position);
        }
        return position <= 26 ? (char)(97 + position - 1) : (char)(65 + position - 27);
    }
}

