/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.unitarou.sgf.Node;
import org.unitarou.util.ArgumentChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Sequence
implements Iterable<Node> {
    private final List<Node> nodes_;

    public Sequence() {
        this.nodes_ = new ArrayList<Node>();
    }

    public Sequence(Sequence src) {
        ArgumentChecker.throwIfNull((Object)src);
        this.nodes_ = new ArrayList<Node>(src.nodes_.size());
        for (Node node : src.nodes_) {
            this.nodes_.add(new Node(node));
        }
    }

    public void addFirst(Node node) {
        this.nodes_.add(0, node);
    }

    public void addLast(Node node) {
        this.nodes_.add(node);
    }

    public void insert(Node node, Node insertPoint) {
        ArgumentChecker.throwIfNull((Object)insertPoint);
        int index = this.nodes_.indexOf(insertPoint);
        if (index == -1) {
            throw new IllegalArgumentException();
        }
        this.nodes_.add(index, node);
    }

    public void addAll(Sequence sequence) {
        ArgumentChecker.throwIfNull((Object)sequence);
        this.nodes_.addAll(sequence.nodes_);
    }

    public boolean remove(Node node) {
        return this.nodes_.remove(node);
    }

    public Node removeLast() {
        return this.nodes_.size() > 0 ? this.nodes_.remove(this.nodes_.size() - 1) : null;
    }

    public void clear() {
        this.nodes_.clear();
    }

    public boolean isEmpty() {
        return this.nodes_.isEmpty();
    }

    public int size() {
        return this.nodes_.size();
    }

    public Node getFirst() {
        return this.nodes_.get(0);
    }

    public Node getLast() {
        return this.nodes_.size() > 0 ? this.nodes_.get(this.nodes_.size() - 1) : null;
    }

    public Node[] getNodes() {
        return this.nodes_.toArray(new Node[this.nodes_.size()]);
    }

    public Iterator iterator() {
        return new Iterator(this.nodes_);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        Sequence des = (Sequence)obj;
        return this.nodes_.equals(des.nodes_);
    }

    public int hashCode() {
        int hash = 0;
        int coef = 1;
        for (Node node : this.nodes_) {
            hash += node.hashCode() * coef;
            coef *= 7;
        }
        return hash;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Iterator
    implements java.util.Iterator<Node> {
        private final ListIterator<Node> iterator_;

        private Iterator(List<Node> list) {
            this.iterator_ = list.listIterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator_.hasNext();
        }

        @Override
        public Node next() {
            return this.iterator_.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

