/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf;

import java.util.Iterator;
import java.util.LinkedHashMap;
import org.unitarou.sgf.CardinalityType;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.Value;
import org.unitarou.sgf.ValueType;
import org.unitarou.util.ArgumentChecker;

public class PropertyValue {
    private final Property property_;
    private final LinkedHashMap<String, Value> valueMap_;

    PropertyValue(Property property) {
        ArgumentChecker.throwIfNull((Object)property);
        this.property_ = property;
        this.valueMap_ = new LinkedHashMap(1);
    }

    public void setValue(Value value) {
        this.checkValue(value, false);
        this.valueMap_.clear();
        this.valueMap_.put(value.getString(), value);
    }

    public int addValue(Value[] values) {
        this.checkValue(values, true);
        if (this.property_.sgfId().cardinalityType().equals(CardinalityType.ELIST) && values.length != 0) {
            if ("".equals(values[0].getString())) {
                this.valueMap_.clear();
                this.valueMap_.put(values[0].getString(), new Value(values[0]));
                return 1;
            }
            this.valueMap_.remove("");
        }
        int count = 0;
        int i = 0;
        while (i < values.length) {
            if (!this.valueMap_.containsKey(values[i].getString())) {
                this.valueMap_.put(values[i].getString(), new Value(values[i]));
                ++count;
            }
            ++i;
        }
        return count;
    }

    public void addValue(Value value) {
        ArgumentChecker.throwIfNull((Object)value);
        if (this.property_.sgfId().cardinalityType().equals(CardinalityType.ELIST)) {
            if ("".equals(value.getString())) {
                this.valueMap_.clear();
            }
            this.valueMap_.remove("");
        }
        this.valueMap_.put(value.getString(), value);
    }

    public boolean removeValue(Value value) {
        this.checkValue(value, true);
        return this.valueMap_.remove(value.getString()) != null;
    }

    public void singularizeIfNeeds() {
        if (1 < this.valueMap_.size() && !ValueType.permitsMultiValues(this.property_.sgfId().cardinalityType())) {
            Value value = this.valueMap_.values().toArray(new Value[this.valueMap_.size()])[0];
            this.valueMap_.clear();
            this.valueMap_.put(value.getString(), value);
        }
    }

    public void clear() {
        this.valueMap_.clear();
    }

    private void checkValue(Object obj, boolean permitsMultiValues) {
        ArgumentChecker.throwIfNull(obj);
        if (permitsMultiValues != ValueType.permitsMultiValues(this.property_.sgfId().cardinalityType())) {
            throw new IllegalStateException("type_.getCardinalityType() is :" + this.property_.sgfId().cardinalityType());
        }
    }

    public String getString() {
        return this.getValue().getString();
    }

    public String[] getStrings() {
        String[] ret = new String[this.valueMap_.size()];
        int index = 0;
        Iterator<Value> ip = this.valueMap_.values().iterator();
        while (ip.hasNext()) {
            ret[index] = ip.next().getString();
            ++index;
        }
        return ret;
    }

    public boolean contains(String string) {
        ArgumentChecker.throwIfNull((Object)string);
        return this.valueMap_.containsKey(string);
    }

    public Value getValue() {
        this.checkValue(this, false);
        return this.valueMap_.values().iterator().next();
    }

    public Value[] getValues() {
        return this.valueMap_.values().toArray(new Value[this.valueMap_.size()]);
    }

    public int size() {
        return this.valueMap_.size();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        PropertyValue target = (PropertyValue)obj;
        return this.valueMap_.equals(target.valueMap_);
    }

    public int hashCode() {
        return this.valueMap_.hashCode();
    }

    public String toString() {
        if (this.valueMap_.isEmpty()) {
            return "<<EMPTY>>";
        }
        StringBuilder sb = new StringBuilder();
        for (Value value : this.valueMap_.values()) {
            sb.append('[').append(value.getString()).append(']');
        }
        return sb.toString();
    }
}

