/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf;

import org.unitarou.sgf.PropertyValue;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.Sgfs;
import org.unitarou.sgf.Value;
import org.unitarou.sgf.ValueType;
import org.unitarou.util.ArgumentChecker;

public final class Property {
    private String entireId_;
    private SgfId sgfId_;
    private final PropertyValue propertyValue_;
    private String openUtr_;
    private String closeUtr_;

    public Property() {
        this.entireId_ = "";
        this.sgfId_ = SgfId.find("");
        this.propertyValue_ = new PropertyValue(this);
        this.openUtr_ = "";
        this.closeUtr_ = "";
    }

    public Property(Property src) {
        ArgumentChecker.throwIfNull((Object)src);
        this.entireId_ = src.entireId_;
        this.sgfId_ = src.sgfId_;
        this.propertyValue_ = new PropertyValue(this);
        if (ValueType.permitsMultiValues(this.sgfId_.cardinalityType())) {
            this.propertyValue_.addValue(src.propertyValue_.getValues());
        } else {
            this.propertyValue_.addValue(src.propertyValue_.getValue());
        }
        this.openUtr_ = src.openUtr_;
        this.closeUtr_ = src.closeUtr_;
    }

    public Property(SgfId type, String string) {
        ArgumentChecker.throwIfNull((Object)type, (Object)string);
        this.entireId_ = type.id();
        this.sgfId_ = type;
        this.propertyValue_ = new PropertyValue(this);
        if (ValueType.permitsMultiValues(this.sgfId_.cardinalityType())) {
            this.propertyValue_.addValue(new Value(string));
        } else {
            this.propertyValue_.setValue(new Value(string));
        }
        this.openUtr_ = "";
        this.closeUtr_ = "";
    }

    public Property(String entireId, String value) {
        ArgumentChecker.throwIfNull((Object)entireId, (Object)value);
        if (!Sgfs.isValidEntireId(entireId)) {
            throw new IllegalArgumentException("Invalid entireId = " + entireId);
        }
        this.entireId_ = entireId;
        this.sgfId_ = SgfId.find(entireId);
        this.propertyValue_ = new PropertyValue(this);
        if (ValueType.permitsMultiValues(this.sgfId_.cardinalityType())) {
            this.propertyValue_.addValue(new Value(value));
        } else {
            this.propertyValue_.setValue(new Value(value));
        }
        this.openUtr_ = "";
        this.closeUtr_ = "";
    }

    public void setId(String id) {
        if (!Sgfs.isValidId(id)) {
            throw new IllegalArgumentException("Bad id = " + id);
        }
        this.entireId_ = id;
        this.sgfId_ = SgfId.find(id);
        this.propertyValue_.singularizeIfNeeds();
    }

    public void setEntireId(String entireId) {
        if (!Sgfs.isValidEntireId(entireId)) {
            throw new IllegalArgumentException("Bad entireId='" + entireId + "'");
        }
        this.entireId_ = entireId;
        this.sgfId_ = SgfId.find(entireId);
        this.propertyValue_.singularizeIfNeeds();
    }

    public void clear() {
        this.entireId_ = "";
        this.sgfId_ = SgfId.find("");
        this.propertyValue_.clear();
        this.openUtr_ = "";
        this.closeUtr_ = "";
    }

    public String getId() {
        return this.sgfId_.id();
    }

    public String getEntireId() {
        return this.entireId_;
    }

    public SgfId sgfId() {
        return this.sgfId_;
    }

    public PropertyValue value() {
        return this.propertyValue_;
    }

    public boolean isValid() {
        return Sgfs.isValidEntireId(this.entireId_) && ValueType.isVaild(this.sgfId_.cardinalityType(), this.propertyValue_.getValues());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        Property target = (Property)obj;
        return this.sgfId_.equals(target.sgfId_) && this.propertyValue_.equals(target.propertyValue_) && this.openUtr_.equals(this.openUtr_) && this.closeUtr_.equals(this.closeUtr_);
    }

    public int hashCode() {
        return this.sgfId_.hashCode() * 5 + this.propertyValue_.hashCode() * 7 + this.openUtr_.hashCode() * 11 + this.closeUtr_.hashCode() * 13;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.openUtr_);
        sb.append(this.entireId_);
        sb.append(this.propertyValue_);
        sb.append(this.closeUtr_);
        return sb.toString();
    }

    public String toSgf() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.openUtr_);
        sb.append(this.entireId_);
        Value[] valueArray = this.propertyValue_.getValues();
        int n = 0;
        int n2 = valueArray.length;
        while (n < n2) {
            Value value = valueArray[n];
            sb.append(value.getOpenUtr());
            sb.append('[');
            sb.append(Sgfs.escapeForStore(value.getString()));
            sb.append(']');
            ++n;
        }
        sb.append(this.closeUtr_);
        return sb.toString();
    }

    public void setOpenUtr(String value) {
        ArgumentChecker.throwIfNull((Object)value);
        this.openUtr_ = value;
    }

    public void setCloseUtr(String value) {
        ArgumentChecker.throwIfNull((Object)value);
        this.closeUtr_ = value;
    }

    public String getOpenUtr() {
        return this.openUtr_;
    }

    public String getCloseUtr() {
        return this.closeUtr_;
    }

    public boolean contains(SgfId sgfId, String string) {
        ArgumentChecker.throwIfNull((Object)sgfId, (Object)string);
        if (!sgfId.equals(this.sgfId_)) {
            return false;
        }
        return this.propertyValue_.contains(string);
    }
}

