/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.unitarou.lang.NullArgumentException;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.PropertyType;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.util.ArgumentChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Node {
    private final ArrayList<Property> properties_;
    private String openUtr_;
    private String closeUtr_;

    public static Node makeMoveNode(SgfColor color, SgfPoint point) {
        ArgumentChecker.throwIfNull((Object)color, (Object)point);
        Property property = color.moveType().makeProperty(point);
        Node node = new Node();
        node.properties_.add(property);
        return node;
    }

    public Node() {
        this.properties_ = new ArrayList();
        this.openUtr_ = "";
        this.closeUtr_ = "";
    }

    public Node(Node src) {
        if (src == null) {
            throw new NullArgumentException();
        }
        this.properties_ = new ArrayList();
        for (Property p : src.properties_) {
            this.properties_.add(new Property(p));
        }
        this.openUtr_ = src.openUtr_;
        this.closeUtr_ = src.closeUtr_;
    }

    public Node(Property property) {
        this();
        if (property != null) {
            if (!property.isValid()) {
                throw new IllegalArgumentException("A property must be valid.");
            }
            this.properties_.add(new Property(property));
        }
    }

    public void addProperty(Property property) {
        if (property == null) {
            throw new NullArgumentException();
        }
        if (!property.isValid()) {
            throw new IllegalArgumentException("A property must be valid. property = " + property);
        }
        int i = 0;
        while (i < this.properties_.size()) {
            Property p = this.properties_.get(i);
            if (p.getId().equals(property.getId())) {
                this.properties_.set(i, new Property(property));
                return;
            }
            ++i;
        }
        this.properties_.add(new Property(property));
    }

    public Property removeProperty(String id) {
        ArgumentChecker.throwIfNull((Object)id);
        Iterator<Property> ip = this.properties_.iterator();
        while (ip.hasNext()) {
            Property property = ip.next();
            if (!property.getId().equals(id)) continue;
            ip.remove();
            return property;
        }
        return null;
    }

    public void clearProperty() {
        this.properties_.clear();
    }

    public boolean contains(SgfId type) {
        ArgumentChecker.throwIfNull((Object)type);
        for (Property property : this.properties_) {
            if (!property.sgfId().equals(type)) continue;
            return true;
        }
        return false;
    }

    public Property getProperty(String id) {
        ArgumentChecker.throwIfNull((Object)id);
        return this.getProperty(SgfId.find(id));
    }

    public Property getProperty(SgfId id) {
        ArgumentChecker.throwIfNull((Object)id);
        for (Property property : this.properties_) {
            if (!property.sgfId().equals(id)) continue;
            return new Property(property);
        }
        return null;
    }

    public Property[] getProperties() {
        Property[] ret = new Property[this.properties_.size()];
        int i = 0;
        while (i < this.properties_.size()) {
            ret[i] = new Property(this.properties_.get(i));
            ++i;
        }
        return ret;
    }

    public Set<SgfId> getPropertyIds() {
        HashSet<SgfId> idSet = new HashSet<SgfId>(this.properties_.size());
        for (Property property : this.properties_) {
            idSet.add(property.sgfId());
        }
        return Collections.unmodifiableSet(idSet);
    }

    public boolean contains(PropertyType propertyType) {
        ArgumentChecker.throwIfNull((Object)propertyType);
        for (Property property : this.properties_) {
            if (!property.sgfId().propertyType().equals(propertyType)) continue;
            return true;
        }
        return false;
    }

    public void setOpenUtr(String value) {
        ArgumentChecker.throwIfNull((Object)value);
        this.openUtr_ = value;
    }

    public void setCloseUtr(String value) {
        ArgumentChecker.throwIfNull((Object)value);
        this.closeUtr_ = value;
    }

    public String getOpenUtr() {
        return this.openUtr_;
    }

    public String getCloseUtr() {
        return this.closeUtr_;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        Node des = (Node)obj;
        return this.properties_.equals(des.properties_) && this.openUtr_.equals(des.openUtr_) && this.closeUtr_.equals(des.closeUtr_);
    }

    public int hashCode() {
        return this.properties_.hashCode() + this.openUtr_.hashCode() * 7 + this.closeUtr_.hashCode() * 11;
    }
}

