/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.unitarou.sgf.Sequence;
import org.unitarou.util.ArgumentChecker;

public class GameTree {
    private GameTree parent_;
    private final Sequence sequence_;
    private final List<GameTree> gameTrees_;
    private String openUtr_;
    private String closeUtr_;

    public GameTree() {
        this.parent_ = null;
        this.sequence_ = new Sequence();
        this.gameTrees_ = new ArrayList<GameTree>();
        this.openUtr_ = "";
        this.closeUtr_ = "";
    }

    public GameTree(GameTree src) {
        ArgumentChecker.throwIfNull((Object)src);
        this.parent_ = src.parent_;
        this.sequence_ = new Sequence(src.sequence_);
        this.gameTrees_ = new ArrayList<GameTree>(src.gameTrees_.size());
        for (GameTree gameTree : src.gameTrees_) {
            GameTree child = new GameTree(gameTree);
            child.parent_ = this;
            this.gameTrees_.add(child);
        }
        this.openUtr_ = src.openUtr_;
        this.closeUtr_ = src.closeUtr_;
    }

    public Sequence getSequence() {
        return this.sequence_;
    }

    public void addGameTree(GameTree child) {
        ArgumentChecker.throwIfNull((Object)child);
        if (this.contains(child)) {
            throw new IllegalArgumentException();
        }
        if (child.countNodes() == 0) {
            return;
        }
        this.gameTrees_.add(child);
        child.parent_ = this;
    }

    public boolean removeGameTree(GameTree child) {
        if (this.gameTrees_.remove(child)) {
            child.parent_ = null;
            return true;
        }
        return false;
    }

    public void clearGameTree() {
        for (GameTree gameTree : this.gameTrees_) {
            if (gameTree.parent_ != this) continue;
            gameTree.parent_ = null;
        }
        this.gameTrees_.clear();
    }

    public GameTree getParent() {
        return this.parent_;
    }

    public GameTree getChild(int index) {
        return this.gameTrees_.get(index);
    }

    public GameTree[] getChildren() {
        return this.gameTrees_.toArray(new GameTree[this.gameTrees_.size()]);
    }

    public int getChildrenSize() {
        return this.gameTrees_.size();
    }

    public int countNodes() {
        int count = 0;
        Iterator<GameTree> ip = this.gameTrees_.iterator();
        while (ip.hasNext()) {
            count += ip.next().countNodes();
        }
        return count += this.sequence_.size();
    }

    public boolean contains(GameTree tree) {
        for (GameTree target : this.gameTrees_) {
            if (target != tree && !target.contains(tree)) continue;
            return true;
        }
        return false;
    }

    public boolean containsDirectly(GameTree tree) {
        return this.gameTrees_.contains(tree);
    }

    public void setOpenUtr(String value) {
        ArgumentChecker.throwIfNull((Object)value);
        this.openUtr_ = value;
    }

    public void setCloseUtr(String value) {
        ArgumentChecker.throwIfNull((Object)value);
        this.closeUtr_ = value;
    }

    public String getOpenUtr() {
        return this.openUtr_;
    }

    public String getCloseUtr() {
        return this.closeUtr_;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        GameTree gt = (GameTree)obj;
        return this.parent_ == gt.parent_ && this.sequence_.equals(gt.sequence_) && this.gameTrees_.equals(gt.gameTrees_) && this.openUtr_.equals(gt.openUtr_) && this.closeUtr_.equals(gt.closeUtr_);
    }

    public int hashCode() {
        return this.sequence_.hashCode() + this.gameTrees_.hashCode() * 7 + this.openUtr_.hashCode() * 11 + this.closeUtr_.hashCode() * 13;
    }
}

