/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf;

import java.io.File;
import java.util.LinkedList;
import java.util.ListIterator;
import org.unitarou.io.FileSnapshot;
import org.unitarou.sgf.CollectionEvent;
import org.unitarou.sgf.CollectionListener;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.parser.SgfParserLogger;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.util.WeakedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Collection
implements Iterable<RootGameTree> {
    private final WeakedList<CollectionListener> listeners_;
    private FileSnapshot fileSnapshot_;
    private SgfParserLogger parserLog_;
    private final LinkedList<RootGameTree> rootGameTrees_;

    public Collection() {
        this.listeners_ = new WeakedList();
        this.fileSnapshot_ = null;
        this.parserLog_ = null;
        this.rootGameTrees_ = new LinkedList();
    }

    public Collection(Collection src) {
        this.fileSnapshot_ = src.fileSnapshot_;
        this.listeners_ = new WeakedList();
        this.listeners_.addAll(src.listeners_);
        this.parserLog_ = src.parserLog_ != null ? new SgfParserLogger(src.parserLog_) : null;
        this.rootGameTrees_ = new LinkedList();
        for (RootGameTree rgt : src.rootGameTrees_) {
            this.rootGameTrees_.add(new RootGameTree(rgt));
        }
    }

    public void addListener(CollectionListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners_.add(listener);
    }

    public void removeListener(CollectionListener listener) {
        this.listeners_.remove(listener);
    }

    public void addLast(RootGameTree rootGameTree) {
        ArgumentChecker.throwIfNull((Object)rootGameTree);
        this.rootGameTrees_.addLast(rootGameTree);
    }

    public boolean remove(RootGameTree rootGameTree) {
        ArgumentChecker.throwIfNull((Object)rootGameTree);
        if (!this.rootGameTrees_.remove(rootGameTree)) {
            return false;
        }
        CollectionEvent event = new CollectionEvent(this, this, rootGameTree);
        for (CollectionListener listener : this.listeners_) {
            listener.rootGameTreeRemoved(event);
        }
        return true;
    }

    public void setFile(File file) {
        this.fileSnapshot_ = file == null ? null : new FileSnapshot(file);
    }

    public void setParserLog(SgfParserLogger log) {
        this.parserLog_ = log;
    }

    public RootGameTree get(int index) {
        return this.rootGameTrees_.get(index);
    }

    public int size() {
        return this.rootGameTrees_.size();
    }

    public File getFile() {
        return this.fileSnapshot_ != null ? this.fileSnapshot_.file() : null;
    }

    public FileSnapshot getFileSnapshot() {
        return this.fileSnapshot_;
    }

    public SgfParserLogger getParserLog() {
        return this.parserLog_;
    }

    public Iterator iterator() {
        return new Iterator(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Iterator
    implements java.util.Iterator<RootGameTree> {
        private final ListIterator<RootGameTree> iterator_;

        private Iterator(Collection collection) {
            this.iterator_ = collection.rootGameTrees_.listIterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator_.hasNext();
        }

        @Override
        public RootGameTree next() {
            return this.iterator_.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

