/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.ml;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.lang.Classes;
import org.unitarou.ml.MessagesEvent;
import org.unitarou.ml.MessagesListener;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.util.WeakedList;

public class Messages {
    private static final Log logger_s_ = LogFactory.getLog(Messages.class);
    private static final String MESSAGES_NAME = "messages";
    private static final Map<String, Messages> messageMap_s_ = new TreeMap<String, Messages>();
    private static Locale currentLocale_s_ = Locale.getDefault();
    private static final WeakedList<MessagesListener> listeners_s_ = new WeakedList();
    private ResourceBundle resourceBundle_ = null;
    private final String bundleName_;
    private final ClassLoader classLoader_;
    private final Set<String> usedKeySet_;
    static /* synthetic */ Class class$0;

    public static Messages createByPackage(Class clazz) {
        ArgumentChecker.throwIfNull((Object)clazz);
        return Messages.createByPackage(clazz, MESSAGES_NAME, clazz.getClassLoader());
    }

    public static Messages createByPackage(Class clazz, ClassLoader classLoader) {
        ArgumentChecker.throwIfNull((Object)clazz, (Object)classLoader);
        return Messages.createByPackage(clazz, MESSAGES_NAME, classLoader);
    }

    public static Messages createByPackage(Class clazz, String fileName) {
        ArgumentChecker.throwIfNull((Object)clazz, (Object)fileName);
        return Messages.createByPackage(clazz, fileName, clazz.getClassLoader());
    }

    public static Messages createByPackage(Class clazz, String fileName, ClassLoader classLoader) {
        ArgumentChecker.throwIfNull((Object)clazz, (Object)fileName, (Object)classLoader);
        StringBuilder stringBuffer = new StringBuilder();
        stringBuffer.append(Classes.packageName(clazz)).append('.').append(fileName);
        String baseName = stringBuffer.toString();
        Messages messages = messageMap_s_.get(baseName);
        if (messages == null) {
            messages = new Messages(baseName, classLoader);
        }
        return messages;
    }

    public static String createKey(Class clazz, String key) {
        ArgumentChecker.throwIfNull((Object)clazz, (Object)key);
        return String.valueOf(Classes.simpleName(clazz)) + (key.length() != 0 ? String.valueOf('.') + key : "");
    }

    public static void addMessagesListener(MessagesListener listener) {
        if (listener == null) {
            return;
        }
        listeners_s_.add(listener);
    }

    public static void removeMessagesListener(MessagesListener listener) {
        listeners_s_.remove(listener);
    }

    public static void changeLocale(Locale locale) {
        ArgumentChecker.throwIfNull((Object)locale);
        if (locale.equals(currentLocale_s_)) {
            return;
        }
        currentLocale_s_ = locale;
        Iterator<Messages> ip = messageMap_s_.values().iterator();
        while (ip.hasNext()) {
            ip.next().makeResoureBundle();
        }
        MessagesEvent event = new MessagesEvent(Messages.class, currentLocale_s_);
        for (MessagesListener messagesListener : listeners_s_) {
            messagesListener.changeLocale(event);
        }
    }

    public static void inspectUnusedMessages() {
        if (!logger_s_.isDebugEnabled()) {
            return;
        }
        for (Messages messages : messageMap_s_.values()) {
            Enumeration<String> jp = messages.resourceBundle_.getKeys();
            while (jp.hasMoreElements()) {
                String key = jp.nextElement();
                if (messages.usedKeySet_.contains(key)) continue;
                logger_s_.debug(String.valueOf(key) + " (bundleName: " + messages.bundleName_ + ")is not used.");
            }
        }
    }

    private Messages(String bundleName, ClassLoader classLoader) {
        this.bundleName_ = bundleName;
        this.classLoader_ = classLoader;
        this.usedKeySet_ = Collections.synchronizedSet(new HashSet());
        this.makeResoureBundle();
        messageMap_s_.put(bundleName, this);
    }

    private void makeResoureBundle() {
        try {
            this.resourceBundle_ = ResourceBundle.getBundle(this.bundleName_, currentLocale_s_, this.classLoader_);
        }
        catch (MissingResourceException e) {
            logger_s_.warn("Can not find resource bundle. Use pseudo object. Bundle name=" + this.bundleName_ + ", Class loader=" + this.classLoader_ + ", Current locale=" + currentLocale_s_);
            this.resourceBundle_ = new PseudoResourceBundle();
        }
    }

    public boolean contains(String key) {
        ArgumentChecker.throwIfNull((Object)key);
        try {
            this.resourceBundle_.getString(key);
            return true;
        }
        catch (MissingResourceException e) {
            return false;
        }
    }

    public String get(String key) {
        ArgumentChecker.throwIfNull((Object)key);
        return this.getString(key);
    }

    public String get(String key, Object[] parameters) {
        ArgumentChecker.throwIfNull((Object)key, (Object)parameters);
        return MessageFormat.format(this.getString(key), parameters);
    }

    public String get(String key, Object parameter) {
        return this.get(key, new Object[]{parameter});
    }

    private String getString(String key) {
        String ret;
        try {
            ret = this.resourceBundle_.getString(key);
            if (logger_s_.isDebugEnabled()) {
                this.usedKeySet_.add(key);
            }
        }
        catch (MissingResourceException e) {
            logger_s_.warn("Cannot find the key = " + key);
            logger_s_.debug("Plz find a lost key from:", e);
            ret = "!" + key + "!";
        }
        return ret.trim();
    }

    public Properties getAll() {
        Properties properties = new Properties();
        Enumeration<String> ip = this.resourceBundle_.getKeys();
        while (ip.hasMoreElements()) {
            String key = ip.nextElement();
            properties.setProperty(key, this.getString(key));
        }
        return properties;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PseudoResourceBundle
    extends ResourceBundle {
        PseudoResourceBundle() {
        }

        @Override
        protected Object handleGetObject(String key) {
            return null;
        }

        @Override
        public Enumeration<String> getKeys() {
            return new Vector().elements();
        }
    }
}

