/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.memory;

import java.lang.reflect.Constructor;
import java.util.WeakHashMap;
import org.unitarou.lang.NullArgumentException;
import org.unitarou.memory.ReferenceCounterException;

public class ReferenceCounter {
    private final WeakHashMap<Object, Counter> counterMap_;
    private final Constructor constructor_;

    public ReferenceCounter(Class clazz) {
        if (clazz == null) {
            throw new NullArgumentException();
        }
        try {
            this.counterMap_ = new WeakHashMap();
            this.constructor_ = clazz.getConstructor(clazz);
        }
        catch (Exception e) {
            throw new ReferenceCounterException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increment(Object instance) {
        Counter counter;
        this.checkParameter(instance);
        WeakHashMap<Object, Counter> weakHashMap = this.counterMap_;
        synchronized (weakHashMap) {
            counter = this.counterMap_.get(instance);
            if (counter == null) {
                counter = new Counter();
                this.counterMap_.put(instance, counter);
            }
        }
        counter.increase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrement(Object instance) {
        this.checkParameter(instance);
        WeakHashMap<Object, Counter> weakHashMap = this.counterMap_;
        synchronized (weakHashMap) {
            Counter counter = this.counterMap_.get(instance);
            if (counter == null) {
                throw new IllegalArgumentException();
            }
            if (counter.count() == 1) {
                this.counterMap_.remove(instance);
            } else {
                counter.decrease();
            }
        }
    }

    public Object getEditable(Object instance) {
        Object ret;
        block2: {
            this.decrement(instance);
            ret = null;
            try {
                ret = this.constructor_.newInstance(instance);
                this.increment(ret);
            }
            catch (Exception ignore) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)"Never reach this Statement.");
            }
        }
        return ret;
    }

    public int count(Object instance) {
        this.checkParameter(instance);
        Counter counter = this.counterMap_.get(instance);
        return counter == null ? 0 : counter.count_;
    }

    public int size() {
        return this.counterMap_.size();
    }

    private void checkParameter(Object instance) {
        if (instance == null) {
            throw new NullArgumentException();
        }
        if (!this.constructor_.getDeclaringClass().equals(instance.getClass())) {
            throw new IllegalArgumentException(instance + "is not an instance of " + this.constructor_.getDeclaringClass());
        }
    }

    private static final class Counter {
        private int count_ = 0;

        Counter() {
        }

        private void increase() {
            ++this.count_;
        }

        private void decrease() {
            --this.count_;
        }

        private int count() {
            return this.count_;
        }
    }
}

