/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.lang;

import java.text.StringCharacterIterator;
import org.unitarou.util.ArgumentChecker;

public class Strings {
    public static final String EMPTY = "";
    public static final String NULL_MARK = "<<null>>";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public static boolean equalsIgnoreEolType(String s1, String s2) {
        if (s1 == null) {
            return s2 == null;
        }
        if (s2 == null) {
            return false;
        }
        StringCharacterIterator i1 = new StringCharacterIterator(s1);
        StringCharacterIterator i2 = new StringCharacterIterator(s2);
        char c1 = i1.first();
        char c2 = i2.first();
        while (true) {
            if (c1 == '\r' && (c1 = i1.next()) != '\n') {
                c1 = i1.previous();
            }
            if (c2 == '\r' && (c2 = i2.next()) != '\n') {
                c2 = i2.previous();
            }
            if (!(c1 != '\r' && c1 != '\n' || c2 != '\r' && c2 != '\n')) {
                c1 = i1.next();
                c2 = i2.next();
                continue;
            }
            if (c1 != c2) break;
            if (c1 == '\uffff') {
                return true;
            }
            c1 = i1.next();
            c2 = i2.next();
        }
        return false;
    }

    public static boolean isUppercaseRomanAlphabet(char c) {
        return 'A' <= c && c <= 'Z';
    }

    public static String formatDuration(int second) {
        int min = second / 60;
        StringBuilder sb = new StringBuilder();
        sb.append(min).append(':');
        if ((second %= 60) < 10) {
            sb.append('0');
        }
        sb.append(second);
        return sb.toString();
    }

    public static String nullToNullMark(String target) {
        return target != null ? target : NULL_MARK;
    }

    public static int calcDiffSize(String string1, String string2) {
        ArgumentChecker.throwIfNull((Object)string1, (Object)string2);
        return Math.max(string1.length(), string2.length()) - Strings.calcLscLength(string1, string2);
    }

    public static int calcLscLength(String string1, String string2) {
        ArgumentChecker.throwIfNull((Object)string1, (Object)string2);
        if (string1.length() == 0 || string2.length() == 0) {
            return 0;
        }
        int[][] hitTable = new int[string1.length() + 1][string2.length() + 1];
        int ret = 0;
        int idx1 = 1;
        while (idx1 < hitTable.length) {
            int idx2 = 1;
            while (idx2 < hitTable[idx1].length) {
                hitTable[idx1][idx2] = string1.charAt(idx1 - 1) == string2.charAt(idx2 - 1) ? hitTable[idx1 - 1][idx2 - 1] + 1 : Math.max(hitTable[idx1 - 1][idx2], hitTable[idx1][idx2 - 1]);
                ret = Math.max(ret, hitTable[idx1][idx2]);
                ++idx2;
            }
            ++idx1;
        }
        return ret;
    }

    protected Strings() {
    }
}

