/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.lang;

import org.unitarou.lang.Classes;

public class Runtimes {
    public static long availableMemory() {
        Runtime runtime = Runtime.getRuntime();
        return runtime.maxMemory() - (runtime.totalMemory() - runtime.freeMemory());
    }

    public static long byteToMegabyte(long byteValue) {
        return (long)(0.5 + (double)byteValue / 1048576.0);
    }

    public static String formatStackTrace(int level) {
        StringBuilder ret = new StringBuilder();
        StackTraceElement[] elements = Thread.currentThread().getStackTrace();
        int i = 4;
        while (i < 4 + level) {
            StackTraceElement element = elements[i];
            ret.append(Classes.simpleName(element.getClassName())).append('#').append(element.getMethodName()).append("()@").append(element.getLineNumber());
            if (i != level + 3) {
                ret.append(" <= ");
            }
            ++i;
        }
        return ret.toString();
    }

    protected Runtimes() {
    }
}

